"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.find = find;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _get_maintenance_window_from_raw = require("../get_maintenance_window_from_raw");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function find(context) {
  const {
    savedObjectsClient,
    logger
  } = context;
  try {
    const result = await savedObjectsClient.find({
      type: _common.MAINTENANCE_WINDOW_SAVED_OBJECT_TYPE
    });
    return {
      data: result.saved_objects.map(so => (0, _get_maintenance_window_from_raw.getMaintenanceWindowFromRaw)({
        attributes: so.attributes,
        id: so.id
      }))
    };
  } catch (e) {
    const errorMessage = `Failed to find maintenance window, Error: ${e}`;
    logger.error(errorMessage);
    throw _boom.default.boomify(e, {
      message: errorMessage
    });
  }
}