"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.archive = archive;
var _moment = _interopRequireDefault(require("moment"));
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _generate_maintenance_window_events = require("../generate_maintenance_window_events");
var _get_maintenance_window_from_raw = require("../get_maintenance_window_from_raw");
var _common = require("../../../common");
var _retry_if_conflicts = require("../../lib/retry_if_conflicts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getArchivedExpirationDate = shouldArchive => {
  if (shouldArchive) {
    return new Date().toISOString();
  }
  return _moment.default.utc().add(1, 'year').toISOString();
};
async function archive(context, params) {
  return await (0, _retry_if_conflicts.retryIfConflicts)(context.logger, `maintenanceWindowClient.archive('${params.id})`, async () => {
    return await archiveWithOCC(context, params);
  });
}
async function archiveWithOCC(context, params) {
  const {
    savedObjectsClient,
    getModificationMetadata,
    logger
  } = context;
  const {
    id,
    archive: shouldArchive
  } = params;
  const modificationMetadata = await getModificationMetadata();
  const expirationDate = getArchivedExpirationDate(shouldArchive);
  try {
    const {
      attributes,
      version
    } = await savedObjectsClient.get(_common.MAINTENANCE_WINDOW_SAVED_OBJECT_TYPE, id);
    const events = (0, _generate_maintenance_window_events.mergeEvents)({
      newEvents: (0, _generate_maintenance_window_events.generateMaintenanceWindowEvents)({
        rRule: attributes.rRule,
        duration: attributes.duration,
        expirationDate
      }),
      oldEvents: attributes.events
    });
    const result = await savedObjectsClient.update(_common.MAINTENANCE_WINDOW_SAVED_OBJECT_TYPE, id, {
      ...attributes,
      events,
      expirationDate,
      updatedAt: modificationMetadata.updatedAt,
      updatedBy: modificationMetadata.updatedBy
    }, {
      version
    });
    return (0, _get_maintenance_window_from_raw.getMaintenanceWindowFromRaw)({
      attributes: {
        ...attributes,
        ...result.attributes
      },
      id
    });
  } catch (e) {
    const errorMessage = `Failed to archive maintenance window by id: ${id}, Error: ${e}`;
    logger.error(errorMessage);
    throw _boom.default.boomify(e, {
      message: errorMessage
    });
  }
}