"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegacyAlertsClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _alert = require("../alert/alert");
var _create_alert_factory = require("../alert/create_alert_factory");
var _lib = require("../lib");
var _trim_recovered_alerts = require("../lib/trim_recovered_alerts");
var _log_alerts = require("../task_runner/log_alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LegacyAlertsClient {
  constructor(options) {
    (0, _defineProperty2.default)(this, "activeAlertsFromPreviousExecution", void 0);
    (0, _defineProperty2.default)(this, "recoveredAlertsFromPreviousExecution", void 0);
    (0, _defineProperty2.default)(this, "alerts", void 0);
    (0, _defineProperty2.default)(this, "processedAlerts", void 0);
    (0, _defineProperty2.default)(this, "alertFactory", void 0);
    this.options = options;
    this.alerts = {};
    this.activeAlertsFromPreviousExecution = {};
    this.recoveredAlertsFromPreviousExecution = {};
    this.processedAlerts = {
      new: {},
      active: {},
      activeCurrent: {},
      recovered: {},
      recoveredCurrent: {}
    };
  }
  initialize(activeAlertsFromState, recoveredAlertsFromState, maintenanceWindowIds) {
    var _this$options$ruleTyp, _this$options$ruleTyp2;
    for (const id in activeAlertsFromState) {
      if (activeAlertsFromState.hasOwnProperty(id)) {
        this.activeAlertsFromPreviousExecution[id] = new _alert.Alert(id, activeAlertsFromState[id]);
      }
    }
    for (const id in recoveredAlertsFromState) {
      if (recoveredAlertsFromState.hasOwnProperty(id)) {
        this.recoveredAlertsFromPreviousExecution[id] = new _alert.Alert(id, recoveredAlertsFromState[id]);
      }
    }
    this.alerts = (0, _lodash.cloneDeep)(this.activeAlertsFromPreviousExecution);
    this.alertFactory = (0, _create_alert_factory.createAlertFactory)({
      alerts: this.alerts,
      logger: this.options.logger,
      maxAlerts: this.options.maxAlerts,
      autoRecoverAlerts: (_this$options$ruleTyp = this.options.ruleType.autoRecoverAlerts) !== null && _this$options$ruleTyp !== void 0 ? _this$options$ruleTyp : true,
      canSetRecoveryContext: (_this$options$ruleTyp2 = this.options.ruleType.doesSetRecoveryContext) !== null && _this$options$ruleTyp2 !== void 0 ? _this$options$ruleTyp2 : false,
      maintenanceWindowIds
    });
  }
  processAndLogAlerts({
    eventLogger,
    ruleLabel,
    ruleRunMetricsStore,
    shouldLogAndScheduleActionsForAlerts,
    flappingSettings,
    notifyWhen,
    maintenanceWindowIds
  }) {
    var _this$options$ruleTyp3;
    const {
      newAlerts: processedAlertsNew,
      activeAlerts: processedAlertsActive,
      currentRecoveredAlerts: processedAlertsRecoveredCurrent,
      recoveredAlerts: processedAlertsRecovered
    } = (0, _lib.processAlerts)({
      alerts: this.alerts,
      existingAlerts: this.activeAlertsFromPreviousExecution,
      previouslyRecoveredAlerts: this.recoveredAlertsFromPreviousExecution,
      hasReachedAlertLimit: this.alertFactory.hasReachedAlertLimit(),
      alertLimit: this.options.maxAlerts,
      autoRecoverAlerts: this.options.ruleType.autoRecoverAlerts !== undefined ? this.options.ruleType.autoRecoverAlerts : true,
      flappingSettings,
      maintenanceWindowIds
    });
    const {
      trimmedAlertsRecovered,
      earlyRecoveredAlerts
    } = (0, _trim_recovered_alerts.trimRecoveredAlerts)(this.options.logger, processedAlertsRecovered, this.options.maxAlerts);
    const alerts = (0, _lib.getAlertsForNotification)(flappingSettings, notifyWhen, this.options.ruleType.defaultActionGroupId, processedAlertsNew, processedAlertsActive, trimmedAlertsRecovered, processedAlertsRecoveredCurrent);
    alerts.currentRecoveredAlerts = (0, _lodash.merge)(alerts.currentRecoveredAlerts, earlyRecoveredAlerts);
    this.processedAlerts.new = alerts.newAlerts;
    this.processedAlerts.active = alerts.activeAlerts;
    this.processedAlerts.activeCurrent = alerts.currentActiveAlerts;
    this.processedAlerts.recovered = alerts.recoveredAlerts;
    this.processedAlerts.recoveredCurrent = alerts.currentRecoveredAlerts;
    (0, _log_alerts.logAlerts)({
      logger: this.options.logger,
      alertingEventLogger: eventLogger,
      newAlerts: alerts.newAlerts,
      activeAlerts: alerts.currentActiveAlerts,
      recoveredAlerts: alerts.currentRecoveredAlerts,
      ruleLogPrefix: ruleLabel,
      ruleRunMetricsStore,
      canSetRecoveryContext: (_this$options$ruleTyp3 = this.options.ruleType.doesSetRecoveryContext) !== null && _this$options$ruleTyp3 !== void 0 ? _this$options$ruleTyp3 : false,
      shouldPersistAlerts: shouldLogAndScheduleActionsForAlerts
    });
  }
  getProcessedAlerts(type) {
    if (this.processedAlerts.hasOwnProperty(type)) {
      return this.processedAlerts[type];
    }
    return {};
  }
  getAlertsToSerialize() {
    return (0, _lib.determineAlertsToReturn)(this.processedAlerts.active, this.processedAlerts.recovered);
  }
  hasReachedAlertLimit() {
    return this.alertFactory.hasReachedAlertLimit();
  }
  checkLimitUsage() {
    return this.alertFactory.alertLimit.checkLimitUsage();
  }
  getExecutorServices() {
    return (0, _create_alert_factory.getPublicAlertFactory)(this.alertFactory);
  }
  setFlapping(flappingSettings) {
    (0, _lib.setFlapping)(flappingSettings, this.processedAlerts.active, this.processedAlerts.recovered);
  }
}
exports.LegacyAlertsClient = LegacyAlertsClient;