"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.MaintenanceWindowsEditPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _use_navigation = require("../../hooks/use_navigation");
var i18n = _interopRequireWildcard(require("./translations"));
var _page_header = require("./components/page_header");
var _create_maintenance_windows_form = require("./components/create_maintenance_windows_form");
var _config = require("../../config");
var _use_get_maintenance_window = require("../../hooks/use_get_maintenance_window");
var _center_justified_spinner = require("./components/center_justified_spinner");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MaintenanceWindowsEditPage = /*#__PURE__*/_react.default.memo(() => {
  const {
    navigateToMaintenanceWindows
  } = (0, _use_navigation.useMaintenanceWindowsNavigation)();
  (0, _use_breadcrumbs.useBreadcrumbs)(_config.AlertingDeepLinkId.maintenanceWindowsEdit);
  const {
    maintenanceWindowId
  } = (0, _reactRouterDom.useParams)();
  const {
    maintenanceWindow,
    isLoading,
    isError
  } = (0, _use_get_maintenance_window.useGetMaintenanceWindow)(maintenanceWindowId);
  if (isError) {
    navigateToMaintenanceWindows();
  }
  if (!maintenanceWindow || isLoading) {
    return /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true
  }, /*#__PURE__*/_react.default.createElement(_page_header.PageHeader, {
    showBackButton: true,
    title: i18n.EDIT_MAINTENANCE_WINDOW
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_create_maintenance_windows_form.CreateMaintenanceWindowForm, {
    initialValue: maintenanceWindow,
    maintenanceWindowId: maintenanceWindowId,
    onCancel: navigateToMaintenanceWindows,
    onSuccess: navigateToMaintenanceWindows
  }));
});
exports.default = exports.MaintenanceWindowsEditPage = MaintenanceWindowsEditPage;
MaintenanceWindowsEditPage.displayName = 'MaintenanceWindowsEditPage';
// eslint-disable-next-line import/no-default-export