"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEEKDAY_OPTIONS = exports.STATUS_SORT = exports.STATUS_OPTIONS = exports.STATUS_DISPLAY = exports.RRULE_WEEKDAYS_TO_ISO_WEEKDAYS = exports.RECURRENCE_END_OPTIONS = exports.ISO_WEEKDAYS_TO_RRULE = exports.Frequency = exports.EndsOptions = exports.DEFAULT_PRESETS = exports.DEFAULT_FREQUENCY_OPTIONS = exports.CREATE_FORM_CUSTOM_FREQUENCY = void 0;
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var i18n = _interopRequireWildcard(require("./translations"));
var _common = require("../../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// TODO - consolidate enum with backend
let Frequency;
exports.Frequency = Frequency;
(function (Frequency) {
  Frequency["YEARLY"] = "0";
  Frequency["MONTHLY"] = "1";
  Frequency["WEEKLY"] = "2";
  Frequency["DAILY"] = "3";
})(Frequency || (exports.Frequency = Frequency = {}));
const DEFAULT_FREQUENCY_OPTIONS = [{
  text: i18n.CREATE_FORM_FREQUENCY_DAILY,
  value: Frequency.DAILY
}, {
  text: i18n.CREATE_FORM_FREQUENCY_WEEKLY,
  value: Frequency.WEEKLY
}, {
  text: i18n.CREATE_FORM_FREQUENCY_MONTHLY,
  value: Frequency.MONTHLY
}, {
  text: i18n.CREATE_FORM_FREQUENCY_YEARLY,
  value: Frequency.YEARLY
}, {
  text: i18n.CREATE_FORM_FREQUENCY_CUSTOM,
  value: 'CUSTOM'
}];
exports.DEFAULT_FREQUENCY_OPTIONS = DEFAULT_FREQUENCY_OPTIONS;
const DEFAULT_PRESETS = {
  [Frequency.DAILY]: {
    interval: 1
  },
  [Frequency.WEEKLY]: {
    interval: 1
  },
  [Frequency.MONTHLY]: {
    interval: 1
  },
  [Frequency.YEARLY]: {
    interval: 1
  }
};
exports.DEFAULT_PRESETS = DEFAULT_PRESETS;
let EndsOptions;
exports.EndsOptions = EndsOptions;
(function (EndsOptions) {
  EndsOptions["NEVER"] = "never";
  EndsOptions["ON_DATE"] = "ondate";
  EndsOptions["AFTER_X"] = "afterx";
})(EndsOptions || (exports.EndsOptions = EndsOptions = {}));
const RECURRENCE_END_OPTIONS = [{
  id: 'never',
  label: i18n.CREATE_FORM_ENDS_NEVER
}, {
  id: 'ondate',
  label: i18n.CREATE_FORM_ENDS_ON_DATE
}, {
  id: 'afterx',
  label: i18n.CREATE_FORM_ENDS_AFTER_X
}];
exports.RECURRENCE_END_OPTIONS = RECURRENCE_END_OPTIONS;
const CREATE_FORM_CUSTOM_FREQUENCY = (interval = 1) => [{
  text: i18n.CREATE_FORM_CUSTOM_FREQUENCY_DAILY(interval),
  value: Frequency.DAILY
}, {
  text: i18n.CREATE_FORM_CUSTOM_FREQUENCY_WEEKLY(interval),
  value: Frequency.WEEKLY
}, {
  text: i18n.CREATE_FORM_CUSTOM_FREQUENCY_MONTHLY(interval),
  value: Frequency.MONTHLY
}, {
  text: i18n.CREATE_FORM_CUSTOM_FREQUENCY_YEARLY(interval),
  value: Frequency.YEARLY
}];
exports.CREATE_FORM_CUSTOM_FREQUENCY = CREATE_FORM_CUSTOM_FREQUENCY;
const WEEKDAY_OPTIONS = _common.ISO_WEEKDAYS.map(n => ({
  id: String(n),
  label: (0, _moment.default)().isoWeekday(n).format('ddd')
}));
exports.WEEKDAY_OPTIONS = WEEKDAY_OPTIONS;
const ISO_WEEKDAYS_TO_RRULE = {
  1: 'MO',
  2: 'TU',
  3: 'WE',
  4: 'TH',
  5: 'FR',
  6: 'SA',
  7: 'SU'
};
exports.ISO_WEEKDAYS_TO_RRULE = ISO_WEEKDAYS_TO_RRULE;
const RRULE_WEEKDAYS_TO_ISO_WEEKDAYS = (0, _lodash.mapValues)((0, _lodash.invert)(ISO_WEEKDAYS_TO_RRULE), v => Number(v));
exports.RRULE_WEEKDAYS_TO_ISO_WEEKDAYS = RRULE_WEEKDAYS_TO_ISO_WEEKDAYS;
const STATUS_DISPLAY = {
  [_common.MaintenanceWindowStatus.Running]: {
    color: 'primary',
    label: i18n.TABLE_STATUS_RUNNING
  },
  [_common.MaintenanceWindowStatus.Upcoming]: {
    color: 'warning',
    label: i18n.TABLE_STATUS_UPCOMING
  },
  [_common.MaintenanceWindowStatus.Finished]: {
    color: 'success',
    label: i18n.TABLE_STATUS_FINISHED
  },
  [_common.MaintenanceWindowStatus.Archived]: {
    color: 'default',
    label: i18n.TABLE_STATUS_ARCHIVED
  }
};
exports.STATUS_DISPLAY = STATUS_DISPLAY;
const STATUS_SORT = {
  [_common.MaintenanceWindowStatus.Running]: 0,
  [_common.MaintenanceWindowStatus.Upcoming]: 1,
  [_common.MaintenanceWindowStatus.Finished]: 2,
  [_common.MaintenanceWindowStatus.Archived]: 3
};
exports.STATUS_SORT = STATUS_SORT;
const STATUS_OPTIONS = [{
  value: _common.MaintenanceWindowStatus.Running,
  name: i18n.TABLE_STATUS_RUNNING
}, {
  value: _common.MaintenanceWindowStatus.Upcoming,
  name: i18n.TABLE_STATUS_UPCOMING
}, {
  value: _common.MaintenanceWindowStatus.Finished,
  name: i18n.TABLE_STATUS_FINISHED
}, {
  value: _common.MaintenanceWindowStatus.Archived,
  name: i18n.TABLE_STATUS_ARCHIVED
}];
exports.STATUS_OPTIONS = STATUS_OPTIONS;