"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schema = void 0;
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var i18n = _interopRequireWildcard(require("../translations"));
var _constants = require("../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _helpers.fieldValidators;
const schema = {
  title: {
    type: _hook_form_lib.FIELD_TYPES.TEXT,
    label: i18n.NAME,
    validations: [{
      validator: emptyField(i18n.CREATE_FORM_NAME_REQUIRED)
    }]
  },
  startDate: {},
  endDate: {},
  timezone: {},
  recurring: {
    type: _hook_form_lib.FIELD_TYPES.TOGGLE,
    label: i18n.CREATE_FORM_REPEAT,
    defaultValue: false
  },
  recurringSchedule: {
    frequency: {
      type: _hook_form_lib.FIELD_TYPES.SELECT,
      label: i18n.CREATE_FORM_REPEAT,
      defaultValue: _constants.Frequency.DAILY
    },
    interval: {
      type: _hook_form_lib.FIELD_TYPES.NUMBER,
      label: '',
      defaultValue: 1,
      validations: [{
        validator: emptyField(i18n.CREATE_FORM_INTERVAL_REQUIRED)
      }]
    },
    ends: {
      label: i18n.CREATE_FORM_ENDS,
      defaultValue: _constants.EndsOptions.NEVER,
      validations: []
    },
    until: {},
    count: {
      label: '',
      type: _hook_form_lib.FIELD_TYPES.TEXT,
      defaultValue: 1,
      validations: [{
        validator: emptyField(i18n.CREATE_FORM_COUNT_REQUIRED)
      }]
    },
    customFrequency: {
      type: _hook_form_lib.FIELD_TYPES.SELECT,
      label: '',
      defaultValue: _constants.Frequency.WEEKLY
    },
    byweekday: {},
    bymonth: {}
  }
};
exports.schema = schema;