"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkIcon = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getStyles(iconSide) {
  return {
    link: (0, _react2.css)`
      align-items: center;
      display: inline-flex;
      vertical-align: top;
      white-space: nowrap;
      flex-direction: ${iconSide === 'left' ? 'row' : 'row-reverse'};
    `,
    leftSide: (0, _react2.css)`
      margin-right: ${_uiTheme.euiThemeVars.euiSizeXS};
    `,
    rightSide: (0, _react2.css)`
      flex-direction: row-reverse;

      .euiIcon {
        margin-left: ${_uiTheme.euiThemeVars.euiSizeXS};
      }
    `
  };
}
const LinkIcon = /*#__PURE__*/_react.default.memo(({
  ariaLabel,
  children,
  color,
  dataTestSubj,
  disabled,
  iconSide = 'left',
  iconSize = 's',
  iconType,
  onClick,
  ...rest
}) => {
  const styles = getStyles(iconSide);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    css: styles.link,
    color: color,
    "data-test-subj": dataTestSubj,
    disabled: disabled,
    onClick: onClick,
    "aria-label": ariaLabel
  }, rest), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    css: iconSide === 'left' ? styles.leftSide : styles.rightSide,
    "data-test-subj": "link-icon",
    size: iconSize,
    type: iconType
  }), /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "link-icon-label"
  }, children));
});
exports.LinkIcon = LinkIcon;
LinkIcon.displayName = 'LinkIcon';