"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatePickerRangeField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var i18n = _interopRequireWildcard(require("../../translations"));
var _get_selected_for_date_picker = require("../../helpers/get_selected_for_date_picker");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DatePickerRangeField = /*#__PURE__*/_react.default.memo(({
  fields,
  timezone,
  showTimeSelect = true,
  ...rest
}) => {
  const [today] = (0, _react.useState)((0, _moment.default)());
  const {
    setFieldValue
  } = (0, _hook_form_lib.useFormContext)();
  const [form] = (0, _hook_form_lib.useFormData)({
    watch: [fields.startDate.path, fields.endDate.path]
  });
  const {
    selected: startDate,
    utcOffset: startOffset
  } = (0, _get_selected_for_date_picker.getSelectedForDatePicker)(form, fields.startDate.path, timezone);
  const {
    selected: endDate,
    utcOffset: endOffset
  } = (0, _get_selected_for_date_picker.getSelectedForDatePicker)(form, fields.endDate.path, timezone);
  const onStartDateChange = (0, _react.useCallback)(currentDate => {
    if (currentDate && currentDate.isAfter(endDate)) {
      // if the current start date is ahead of the end date
      // set the end date to the current start date + 30 min
      const updatedEndDate = (0, _moment.default)(currentDate).add(30, 'minutes');
      setFieldValue(fields.endDate.path, updatedEndDate);
    }
    // convert the moment date back into a string if it's not null
    setFieldValue(fields.startDate.path, currentDate ? currentDate.toISOString() : currentDate);
  }, [setFieldValue, endDate, fields.endDate.path, fields.startDate.path]);
  const onEndDateChange = (0, _react.useCallback)(currentDate => {
    // convert the moment date back into a string if it's not null
    setFieldValue(fields.endDate.path, currentDate ? currentDate.toISOString() : currentDate);
  }, [setFieldValue, fields.endDate.path]);
  const isInvalid = startDate.isAfter(endDate);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: fields.startDate.label
  }, rest, {
    fullWidth: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDatePickerRange, {
    isInvalid: isInvalid,
    startDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      selected: startDate,
      onChange: date => date && onStartDateChange(date),
      startDate: startDate,
      endDate: endDate,
      "aria-label": "Start date",
      showTimeSelect: showTimeSelect,
      minDate: today,
      utcOffset: startOffset
    }),
    endDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      selected: endDate,
      onChange: date => date && onEndDateChange(date),
      startDate: startDate,
      endDate: endDate,
      "aria-label": "End date",
      showTimeSelect: showTimeSelect,
      minDate: today,
      utcOffset: endOffset
    }),
    fullWidth: true
  })), isInvalid ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger"
  }, i18n.CREATE_FORM_SCHEDULE_INVALID)) : null);
});
exports.DatePickerRangeField = DatePickerRangeField;
DatePickerRangeField.displayName = 'DatePickerRangeField';