"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatePickerField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _get_selected_for_date_picker = require("../../helpers/get_selected_for_date_picker");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DatePickerField = /*#__PURE__*/_react.default.memo(({
  field,
  showTimeSelect = true,
  ...rest
}) => {
  const [today] = (0, _react.useState)((0, _moment.default)());
  const {
    setFieldValue
  } = (0, _hook_form_lib.useFormContext)();
  const [form] = (0, _hook_form_lib.useFormData)({
    watch: [field.path]
  });
  const {
    selected,
    utcOffset
  } = (0, _get_selected_for_date_picker.getSelectedForDatePicker)(form, field.path);
  const onChange = (0, _react.useCallback)(currentDate => {
    // convert the moment date back into a string if it's not null
    setFieldValue(field.path, currentDate ? currentDate.toISOString() : currentDate);
  }, [setFieldValue, field.path]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: field.label
  }, rest, {
    fullWidth: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
    showTimeSelect: showTimeSelect,
    selected: selected,
    onChange: onChange,
    minDate: today,
    utcOffset: utcOffset,
    fullWidth: true
  }));
});
exports.DatePickerField = DatePickerField;
DatePickerField.displayName = 'DatePickerField';