"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ButtonGroupField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _lodash = require("lodash");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ButtonGroupField = /*#__PURE__*/_react.default.memo(({
  field,
  legend,
  options,
  type = 'single',
  ...rest
}) => {
  const {
    setFieldValue
  } = (0, _hook_form_lib.useFormContext)();
  const [formData] = (0, _hook_form_lib.useFormData)({
    watch: [field.path]
  });
  const selected = (0, _lodash.get)(formData, field.path);
  const onChange = (0, _react.useCallback)(current => {
    setFieldValue(field.path, current);
  }, [setFieldValue, field.path]);
  const onChangeMulti = (0, _react.useCallback)(current => {
    const newSelectedValue = {
      ...selected,
      [current]: !selected[current]
    };
    // Don't allow the user to deselect all options
    if (!Object.values(newSelectedValue).every(v => v === false)) {
      setFieldValue(field.path, newSelectedValue);
    }
  }, [setFieldValue, selected, field.path]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: field.label
  }, rest, {
    fullWidth: true
  }), type === 'multi' ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: legend,
    onChange: onChangeMulti,
    idToSelectedMap: selected,
    options: options,
    type: "multi"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: legend,
    onChange: onChange,
    idSelected: selected,
    options: options,
    type: "single"
  }));
});
exports.ButtonGroupField = ButtonGroupField;
ButtonGroupField.displayName = 'ButtonGroupField';