"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateMaintenanceWindowForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _eui = require("@elastic/eui");
var _coreUiSettingsCommon = require("@kbn/core-ui-settings-common");
var _schema = require("./schema");
var i18n = _interopRequireWildcard(require("../translations"));
var _recurring_schedule = require("./recurring_schedule_form/recurring_schedule");
var _submit_button = require("./submit_button");
var _convert_to_rrule = require("../helpers/convert_to_rrule");
var _use_create_maintenance_window = require("../../../hooks/use_create_maintenance_window");
var _use_update_maintenance_window = require("../../../hooks/use_update_maintenance_window");
var _kibana_react = require("../../../utils/kibana_react");
var _date_picker_range_field = require("./fields/date_picker_range_field");
var _use_archive_maintenance_window = require("../../../hooks/use_archive_maintenance_window");
var _UI_TIMEZONE_OPTIONS$;
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const UseField = (0, _hook_form_lib.getUseField)({
  component: _components.Field
});
const useDefaultTimezone = () => {
  const kibanaTz = (0, _kibana_react.useUiSetting)('dateFormat:tz');
  if (!kibanaTz || kibanaTz === 'Browser') {
    var _moment$tz$guess, _moment$tz;
    return {
      defaultTimezone: (_moment$tz$guess = (_moment$tz = _moment.default.tz) === null || _moment$tz === void 0 ? void 0 : _moment$tz.guess()) !== null && _moment$tz$guess !== void 0 ? _moment$tz$guess : 'UTC',
      isBrowser: true
    };
  }
  return {
    defaultTimezone: kibanaTz,
    isBrowser: false
  };
};
const TIMEZONE_OPTIONS = (_UI_TIMEZONE_OPTIONS$ = _coreUiSettingsCommon.TIMEZONE_OPTIONS.map(n => ({
  label: n
}))) !== null && _UI_TIMEZONE_OPTIONS$ !== void 0 ? _UI_TIMEZONE_OPTIONS$ : [{
  label: 'UTC'
}];
const CreateMaintenanceWindowForm = /*#__PURE__*/_react.default.memo(({
  onCancel,
  onSuccess,
  initialValue,
  maintenanceWindowId
}) => {
  const [defaultStartDateValue] = (0, _react.useState)((0, _moment.default)().toISOString());
  const [defaultEndDateValue] = (0, _react.useState)((0, _moment.default)().add(30, 'minutes').toISOString());
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const {
    defaultTimezone,
    isBrowser
  } = useDefaultTimezone();
  const isEditMode = initialValue !== undefined && maintenanceWindowId !== undefined;
  const {
    mutate: createMaintenanceWindow,
    isLoading: isCreateLoading
  } = (0, _use_create_maintenance_window.useCreateMaintenanceWindow)();
  const {
    mutate: updateMaintenanceWindow,
    isLoading: isUpdateLoading
  } = (0, _use_update_maintenance_window.useUpdateMaintenanceWindow)();
  const {
    mutate: archiveMaintenanceWindow
  } = (0, _use_archive_maintenance_window.useArchiveMaintenanceWindow)();
  const submitMaintenanceWindow = (0, _react.useCallback)(async (formData, isValid) => {
    if (isValid) {
      const startDate = (0, _moment.default)(formData.startDate);
      const endDate = (0, _moment.default)(formData.endDate);
      const maintenanceWindow = {
        title: formData.title,
        duration: endDate.diff(startDate),
        rRule: (0, _convert_to_rrule.convertToRRule)(startDate, formData.timezone ? formData.timezone[0] : defaultTimezone, formData.recurringSchedule)
      };
      if (isEditMode) {
        updateMaintenanceWindow({
          maintenanceWindowId,
          maintenanceWindow
        }, {
          onSuccess
        });
      } else {
        createMaintenanceWindow(maintenanceWindow, {
          onSuccess
        });
      }
    }
  }, [isEditMode, maintenanceWindowId, updateMaintenanceWindow, createMaintenanceWindow, onSuccess, defaultTimezone]);
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: initialValue,
    options: {
      stripEmptyFields: false
    },
    schema: _schema.schema,
    onSubmit: submitMaintenanceWindow
  });
  const [{
    recurring,
    timezone
  }] = (0, _hook_form_lib.useFormData)({
    form,
    watch: ['recurring', 'timezone']
  });
  const isRecurring = recurring || false;
  const showTimezone = isBrowser || (initialValue === null || initialValue === void 0 ? void 0 : initialValue.timezone) !== undefined;
  const closeModal = (0, _react.useCallback)(() => setIsModalVisible(false), []);
  const showModal = (0, _react.useCallback)(() => setIsModalVisible(true), []);
  const modal = (0, _react.useMemo)(() => {
    let m;
    if (isModalVisible) {
      m = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
        title: i18n.ARCHIVE_TITLE,
        onCancel: closeModal,
        onConfirm: () => {
          closeModal();
          archiveMaintenanceWindow({
            maintenanceWindowId: maintenanceWindowId,
            archive: true
          }, {
            onSuccess
          });
        },
        cancelButtonText: i18n.CANCEL,
        confirmButtonText: i18n.ARCHIVE_TITLE,
        defaultFocusedButton: "confirm",
        buttonColor: "danger"
      }, /*#__PURE__*/_react.default.createElement("p", null, i18n.ARCHIVE_CALLOUT_SUBTITLE));
    }
    return m;
  }, [closeModal, archiveMaintenanceWindow, isModalVisible, maintenanceWindowId, onSuccess]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "title",
    componentProps: {
      'data-test-subj': 'title-field',
      euiFieldProps: {
        autoFocus: true
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseMultiFields, {
    fields: {
      startDate: {
        path: 'startDate',
        config: {
          label: i18n.CREATE_FORM_SCHEDULE,
          defaultValue: defaultStartDateValue,
          validations: []
        }
      },
      endDate: {
        path: 'endDate',
        config: {
          label: '',
          defaultValue: defaultEndDateValue,
          validations: []
        }
      }
    }
  }, fields => /*#__PURE__*/_react.default.createElement(_date_picker_range_field.DatePickerRangeField, {
    fields: fields,
    timezone: timezone !== null && timezone !== void 0 ? timezone : [defaultTimezone],
    "data-test-subj": "date-field"
  }))), showTimezone ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "timezone",
    config: {
      type: _hook_form_lib.FIELD_TYPES.COMBO_BOX,
      validations: [],
      defaultValue: [defaultTimezone]
    },
    componentProps: {
      'data-test-subj': 'timezone-field',
      id: 'timezone',
      euiFieldProps: {
        fullWidth: true,
        options: TIMEZONE_OPTIONS,
        singleSelection: {
          asPlainText: true
        },
        isClearable: false,
        noSuggestions: false,
        placeholder: '',
        prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
          htmlFor: 'timezone'
        }, i18n.CREATE_FORM_TIMEZONE)
      }
    }
  })) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "recurring",
    componentProps: {
      'data-test-subj': 'recurring-field'
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isRecurring ? /*#__PURE__*/_react.default.createElement(_recurring_schedule.RecurringSchedule, {
    "data-test-subj": "recurring-form"
  }) : null)), isEditMode ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.ARCHIVE_TITLE,
    color: "danger",
    iconType: "trash"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.ARCHIVE_SUBTITLE), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "danger",
    onClick: showModal
  }, i18n.ARCHIVE), modal) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    gutterSize: "l",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    size: "s",
    "data-test-subj": "cancelMaintenanceWindow"
  }, i18n.CANCEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_submit_button.SubmitButton, {
    isLoading: isCreateLoading || isUpdateLoading,
    editMode: isEditMode
  }))));
});
exports.CreateMaintenanceWindowForm = CreateMaintenanceWindowForm;
CreateMaintenanceWindowForm.displayName = 'CreateMaintenanceWindowForm';