"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogCategorization = exports.ExplainLogRateSpikes = exports.ChangePointDetection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const ExplainLogRateSpikesAppStateLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/explain_log_rate_spikes'))));
const LazyWrapper = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
  fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
    lines: 3
  })
}, children));

/**
 * Lazy-wrapped ExplainLogRateSpikesAppState React component
 * @param {ExplainLogRateSpikesAppStateProps}  props - properties specifying the data on which to run the analysis.
 */
const ExplainLogRateSpikes = props => /*#__PURE__*/_react.default.createElement(LazyWrapper, null, /*#__PURE__*/_react.default.createElement(ExplainLogRateSpikesAppStateLazy, props));
exports.ExplainLogRateSpikes = ExplainLogRateSpikes;
const LogCategorizationAppStateLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/log_categorization'))));

/**
 * Lazy-wrapped LogCategorizationAppStateProps React component
 * @param {LogCategorizationAppStateProps}  props - properties specifying the data on which to run the analysis.
 */
const LogCategorization = props => /*#__PURE__*/_react.default.createElement(LazyWrapper, null, /*#__PURE__*/_react.default.createElement(LogCategorizationAppStateLazy, props));
exports.LogCategorization = LogCategorization;
const ChangePointDetectionLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/change_point_detection'))));
/**
 * Lazy-wrapped ChangePointDetectionAppStateProps React component
 * @param {ChangePointDetectionAppStateProps}  props - properties specifying the data on which to run the analysis.
 */
const ChangePointDetection = props => /*#__PURE__*/_react.default.createElement(LazyWrapper, null, /*#__PURE__*/_react.default.createElement(ChangePointDetectionLazy, props));
exports.ChangePointDetection = ChangePointDetection;