"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimeBuckets = void 0;
var _react = require("react");
var _common = require("@kbn/data-plugin/common");
var _time_buckets = require("../../common/time_buckets");
var _use_aiops_app_context = require("./use_aiops_app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTimeBuckets = () => {
  const {
    uiSettings
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  return (0, _react.useMemo)(() => {
    return new _time_buckets.TimeBuckets({
      [_common.UI_SETTINGS.HISTOGRAM_MAX_BARS]: uiSettings.get(_common.UI_SETTINGS.HISTOGRAM_MAX_BARS),
      [_common.UI_SETTINGS.HISTOGRAM_BAR_TARGET]: uiSettings.get(_common.UI_SETTINGS.HISTOGRAM_BAR_TARGET),
      dateFormat: uiSettings.get('dateFormat'),
      'dateFormat:scaled': uiSettings.get('dateFormat:scaled')
    });
  }, [uiSettings]);
};
exports.useTimeBuckets = useTimeBuckets;