"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCancellableSearch = useCancellableSearch;
var _react = require("react");
var _common = require("@kbn/data-plugin/common");
var _operators = require("rxjs/operators");
var _use_aiops_app_context = require("./use_aiops_app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useCancellableSearch() {
  const {
    data
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const abortController = (0, _react.useRef)(new AbortController());
  const [isLoading, setIsFetching] = (0, _react.useState)(false);
  const runRequest = (0, _react.useCallback)(requestBody => {
    return new Promise((resolve, reject) => {
      data.search.search(requestBody, {
        abortSignal: abortController.current.signal
      }).pipe((0, _operators.tap)(() => {
        setIsFetching(true);
      })).subscribe({
        next: result => {
          if ((0, _common.isCompleteResponse)(result)) {
            setIsFetching(false);
            resolve(result);
          } else if ((0, _common.isErrorResponse)(result)) {
            reject(result);
          } else {
            // partial results
            // Ignore partial results for now.
            // An issue with the search function means partial results are not being returned correctly.
          }
        },
        error: error => {
          if (error.name === 'AbortError') {
            return resolve(null);
          }
          setIsFetching(false);
          reject(error);
        }
      });
    });
  }, [data.search]);
  const cancelRequest = (0, _react.useCallback)(() => {
    abortController.current.abort();
    abortController.current = new AbortController();
  }, []);
  return {
    runRequest,
    cancelRequest,
    isLoading
  };
}