"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processDocumentCountStats = exports.getDocumentCountStatsRequest = void 0;
var _lodash = require("lodash");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _build_extended_base_filter_criteria = require("./application/utils/build_extended_base_filter_criteria");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDocumentCountStatsRequest = (params, randomSamplerWrapper, skipAggs = false) => {
  const {
    index,
    timeFieldName,
    earliest: earliestMs,
    latest: latestMs,
    runtimeFieldMap,
    searchQuery,
    intervalMs,
    fieldsToFetch,
    selectedSignificantTerm,
    includeSelectedSignificantTerm,
    selectedGroup,
    trackTotalHits
  } = params;
  const size = 0;
  const filterCriteria = (0, _build_extended_base_filter_criteria.buildExtendedBaseFilterCriteria)(timeFieldName, earliestMs, latestMs, searchQuery, selectedSignificantTerm, includeSelectedSignificantTerm, selectedGroup);
  const rawAggs = {
    eventRate: {
      date_histogram: {
        field: timeFieldName,
        fixed_interval: `${intervalMs}ms`,
        min_doc_count: 0,
        ...(earliestMs !== undefined && latestMs !== undefined ? {
          extended_bounds: {
            min: earliestMs,
            max: latestMs
          }
        } : {})
      }
    }
  };
  const aggs = randomSamplerWrapper ? randomSamplerWrapper.wrap(rawAggs) : rawAggs;
  const searchBody = {
    query: {
      bool: {
        filter: filterCriteria
      }
    },
    ...(!fieldsToFetch && !skipAggs && timeFieldName !== undefined && intervalMs !== undefined && intervalMs > 0 ? {
      aggs
    } : {}),
    ...((0, _mlIsPopulatedObject.isPopulatedObject)(runtimeFieldMap) ? {
      runtime_mappings: runtimeFieldMap
    } : {}),
    track_total_hits: trackTotalHits === true,
    size
  };
  return {
    index,
    body: searchBody
  };
};
exports.getDocumentCountStatsRequest = getDocumentCountStatsRequest;
const processDocumentCountStats = (body, params, randomSamplerWrapper) => {
  var _ref, _value;
  if (!body) return undefined;
  const totalCount = (_ref = (_value = body.hits.total.value) !== null && _value !== void 0 ? _value : body.hits.total) !== null && _ref !== void 0 ? _ref : 0;
  if (params.intervalMs === undefined || params.earliest === undefined || params.latest === undefined) {
    return {
      totalCount
    };
  }
  const buckets = {};
  const dataByTimeBucket = (0, _lodash.get)(randomSamplerWrapper && body.aggregations !== undefined ? randomSamplerWrapper.unwrap(body.aggregations) : body.aggregations, ['eventRate', 'buckets'], []);
  (0, _lodash.each)(dataByTimeBucket, dataForTime => {
    const time = dataForTime.key;
    buckets[time] = dataForTime.doc_count;
  });
  return {
    interval: params.intervalMs,
    buckets,
    timeRangeEarliest: params.earliest,
    timeRangeLatest: params.latest,
    totalCount
  };
};
exports.processDocumentCountStats = processDocumentCountStats;