"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGroupTableItems = getGroupTableItems;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getGroupTableItems(significantTermsGroups) {
  const tableItems = significantTermsGroups.map(({
    id,
    group,
    docCount,
    histogram,
    pValue
  }) => {
    const sortedGroup = (0, _lodash.sortBy)(group, [d => d.fieldName]);
    const dedupedGroup = [];
    sortedGroup.forEach(pair => {
      const {
        fieldName,
        fieldValue,
        docCount: pairDocCount,
        pValue: pairPValue,
        duplicate
      } = pair;
      if ((duplicate !== null && duplicate !== void 0 ? duplicate : 0) <= 1) {
        dedupedGroup.push({
          fieldName,
          fieldValue,
          docCount: pairDocCount,
          pValue: pairPValue
        });
      }
    });
    const groupItemsSortedByUniqueness = (0, _lodash.sortBy)(group, ['duplicate', 'docCount']);
    const sortedDedupedGroup = (0, _lodash.sortBy)(dedupedGroup, d => {
      var _d$pValue;
      return [-1 * ((_d$pValue = d.pValue) !== null && _d$pValue !== void 0 ? _d$pValue : 0), d.docCount];
    });
    return {
      id,
      docCount,
      pValue,
      uniqueItemsCount: sortedDedupedGroup.length,
      groupItemsSortedByUniqueness,
      histogram
    };
  });
  return tableItems;
}