"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QUERY_MODE = void 0;
exports.createFilter = createFilter;
exports.useDiscoverLinks = useDiscoverLinks;
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QUERY_MODE = {
  INCLUDE: 'should',
  EXCLUDE: 'must_not'
};
exports.QUERY_MODE = QUERY_MODE;
function useDiscoverLinks() {
  const {
    http: {
      basePath
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const openInDiscoverWithFilter = (index, field, selection, aiopsListState, timefilterActiveBounds, mode, category) => {
    var _timefilterActiveBoun, _timefilterActiveBoun2;
    const _g = _rison.default.encode({
      time: {
        from: (0, _moment.default)((_timefilterActiveBoun = timefilterActiveBounds.min) === null || _timefilterActiveBoun === void 0 ? void 0 : _timefilterActiveBoun.valueOf()).toISOString(),
        to: (0, _moment.default)((_timefilterActiveBoun2 = timefilterActiveBounds.max) === null || _timefilterActiveBoun2 === void 0 ? void 0 : _timefilterActiveBoun2.valueOf()).toISOString()
      }
    });
    const _a = _rison.default.encode({
      filters: [...aiopsListState.filters, createFilter(index, field, selection, mode, category)],
      index,
      interval: 'auto',
      query: {
        language: aiopsListState.searchQueryLanguage,
        query: aiopsListState.searchString
      }
    });
    let path = basePath.get();
    path += '/app/discover#/';
    path += '?_g=' + _g;
    path += '&_a=' + encodeURIComponent(_a);
    window.open(path, '_blank');
  };
  return {
    openInDiscoverWithFilter
  };
}
function createFilter(index, field, selection, mode, category) {
  const selectedRows = category === undefined ? selection : [category];
  return {
    query: {
      bool: {
        [mode]: selectedRows.map(({
          key: query
        }) => ({
          match: {
            [field]: {
              auto_generate_synonyms_phrase_query: false,
              fuzziness: 0,
              operator: 'and',
              query
            }
          }
        }))
      }
    },
    meta: {
      alias: _i18n.i18n.translate('xpack.aiops.logCategorization.filterAliasLabel', {
        defaultMessage: 'Categorization - {field}',
        values: {
          field
        }
      }),
      index,
      disabled: false
    }
  };
}