"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SamplingMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _random_sampler_range_slider = require("./random_sampler_range_slider");
var _random_sampler = require("./random_sampler");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SamplingMenu = ({
  randomSampler,
  reload
}) => {
  const [showSamplingOptionsPopover, setShowSamplingOptionsPopover] = (0, _react.useState)(false);
  const samplingProbability = (0, _useObservable.default)(randomSampler.getProbability$(), randomSampler.getProbability());
  const setSamplingProbability = (0, _react.useCallback)(probability => {
    randomSampler.setProbability(probability);
    reload();
  }, [reload, randomSampler]);
  const randomSamplerPreference = (0, _useObservable.default)(randomSampler.getMode$(), randomSampler.getMode());
  const setRandomSamplerPreference = (0, _react.useCallback)(mode => {
    randomSampler.setMode(mode);
    reload();
  }, [randomSampler, reload]);
  const {
    calloutInfoMessage,
    buttonText
  } = (0, _react.useMemo)(() => {
    switch (randomSamplerPreference) {
      case _random_sampler.RANDOM_SAMPLER_OPTION.OFF:
        return {
          calloutInfoMessage: _i18n.i18n.translate('xpack.aiops.logCategorization.randomSamplerSettingsPopUp.offCallout.message', {
            defaultMessage: 'Random sampling can be turned on to increase the speed of analysis, although some accuracy will be lost.'
          }),
          buttonText: _i18n.i18n.translate('xpack.aiops.logCategorization.randomSamplerSettingsPopUp.offCallout.button', {
            defaultMessage: 'No sampling'
          })
        };
      case _random_sampler.RANDOM_SAMPLER_OPTION.ON_AUTOMATIC:
        return {
          calloutInfoMessage: _i18n.i18n.translate('xpack.aiops.logCategorization.randomSamplerSettingsPopUp.onAutomaticCallout.message', {
            defaultMessage: 'The pattern analysis will use random sampler aggregations. The probability is automatically set to balance accuracy and speed.'
          }),
          buttonText: _i18n.i18n.translate('xpack.aiops.logCategorization.randomSamplerSettingsPopUp.onAutomaticCallout.button', {
            defaultMessage: 'Auto sampling'
          })
        };
      case _random_sampler.RANDOM_SAMPLER_OPTION.ON_MANUAL:
      default:
        return {
          calloutInfoMessage: _i18n.i18n.translate('xpack.aiops.logCategorization.randomSamplerSettingsPopUp.onManualCallout.message', {
            defaultMessage: 'The pattern analysis will use random sampler aggregations. A lower percentage probability increases performance, but some accuracy is lost.'
          }),
          buttonText: _i18n.i18n.translate('xpack.aiops.logCategorization.randomSamplerSettingsPopUp.onManualCallout.button', {
            defaultMessage: 'Manual sampling'
          })
        };
    }
  }, [randomSamplerPreference]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "aiopsRandomSamplerOptionsPopover",
    id: "aiopsSamplingOptions",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => setShowSamplingOptionsPopover(!showSamplingOptionsPopover),
      iconSide: "right",
      iconType: "arrowDown"
    }, buttonText),
    isOpen: showSamplingOptionsPopover,
    closePopover: () => setShowSamplingOptionsPopover(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    style: {
      maxWidth: 400
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: 'primary',
    title: calloutInfoMessage
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "aiopsRandomSamplerOptionsFormRow",
    label: _i18n.i18n.translate('xpack.aiops.logCategorization.randomSamplerSettingsPopUp.randomSamplerRowLabel', {
      defaultMessage: 'Random sampling'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "aiopsRandomSamplerOptionsSelect",
    options: _random_sampler.RANDOM_SAMPLER_SELECT_OPTIONS,
    value: randomSamplerPreference,
    onChange: e => setRandomSamplerPreference(e.target.value)
  })), randomSamplerPreference === _random_sampler.RANDOM_SAMPLER_OPTION.ON_MANUAL ? /*#__PURE__*/_react.default.createElement(_random_sampler_range_slider.RandomSamplerRangeSlider, {
    samplingProbability: samplingProbability,
    setSamplingProbability: setSamplingProbability
  }) : null, randomSamplerPreference === _random_sampler.RANDOM_SAMPLER_OPTION.ON_AUTOMATIC ? /*#__PURE__*/_react.default.createElement(ProbabilityUsedMessage, {
    samplingProbability: samplingProbability
  }) : null));
};
exports.SamplingMenu = SamplingMenu;
const ProbabilityUsedMessage = ({
  samplingProbability
}) => {
  return samplingProbability !== null ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "aiopsRandomSamplerProbabilityUsedMsg"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logCategorization.randomSamplerSettingsPopUp.probabilityLabel",
    defaultMessage: "Probability used: {samplingProbability}%",
    values: {
      samplingProbability: samplingProbability * 100
    }
  })) : null;
};