"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentCountChart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _document_count_chart = require("../document_count_content/document_count_chart");
var _total_count_header = require("../document_count_content/total_count_header");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentCountChart = ({
  eventRate,
  sparkLines,
  totalCount,
  pinnedCategory,
  selectedCategory,
  documentCountStats
}) => {
  const chartPointsSplitLabel = _i18n.i18n.translate('xpack.aiops.logCategorization.chartPointsSplitLabel', {
    defaultMessage: 'Selected pattern'
  });
  const chartPoints = (0, _react.useMemo)(() => {
    var _ref;
    const category = (_ref = selectedCategory !== null && selectedCategory !== void 0 ? selectedCategory : pinnedCategory) !== null && _ref !== void 0 ? _ref : null;
    return eventRate.map(({
      key,
      docCount
    }) => {
      let value = docCount;
      if (category && sparkLines[category.key] && sparkLines[category.key][key]) {
        value -= sparkLines[category.key][key];
      }
      return {
        time: key,
        value
      };
    });
  }, [eventRate, pinnedCategory, selectedCategory, sparkLines]);
  const chartPointsSplit = (0, _react.useMemo)(() => {
    var _ref2;
    const category = (_ref2 = selectedCategory !== null && selectedCategory !== void 0 ? selectedCategory : pinnedCategory) !== null && _ref2 !== void 0 ? _ref2 : null;
    return category !== null ? eventRate.map(({
      key
    }) => {
      const value = sparkLines && sparkLines[category.key] && sparkLines[category.key][key] ? sparkLines[category.key][key] : 0;
      return {
        time: key,
        value
      };
    }) : undefined;
  }, [eventRate, pinnedCategory, selectedCategory, sparkLines]);
  if ((documentCountStats === null || documentCountStats === void 0 ? void 0 : documentCountStats.interval) === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_total_count_header.TotalCountHeader, {
    totalCount: totalCount
  }), /*#__PURE__*/_react.default.createElement(_document_count_chart.DocumentCountChart, {
    chartPoints: chartPoints,
    chartPointsSplit: chartPointsSplit,
    timeRangeEarliest: eventRate[0].key,
    timeRangeLatest: eventRate[eventRate.length - 1].key,
    interval: documentCountStats.interval,
    chartPointsSplitLabel: chartPointsSplitLabel,
    isBrushCleared: false
  }));
};
exports.DocumentCountChart = DocumentCountChart;