"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_eui_theme = require("../../../hooks/use_eui_theme");
var _use_discover_links = require("../use_discover_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TableHeader = ({
  categoriesCount,
  selectedCategoriesCount,
  labels,
  openInDiscover
}) => {
  const euiTheme = (0, _use_eui_theme.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    css: {
      minHeight: euiTheme.euiSizeXL
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logCategorization.counts",
    defaultMessage: "{count} patterns found",
    values: {
      count: categoriesCount
    }
  }), selectedCategoriesCount > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logCategorization.selectedCounts",
    defaultMessage: " | {count} selected",
    values: {
      count: selectedCategoriesCount
    }
  })) : null)), selectedCategoriesCount > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    onClick: () => openInDiscover(_use_discover_links.QUERY_MODE.INCLUDE),
    iconType: "plusInCircle",
    iconSide: "left"
  }, labels.multiSelect.in)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    onClick: () => openInDiscover(_use_discover_links.QUERY_MODE.EXCLUDE),
    iconType: "minusInCircle",
    iconSide: "left"
  }, labels.multiSelect.out))) : null));
};
exports.TableHeader = TableHeader;