"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategoryTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_discover_links = require("../use_discover_links");
var _mini_histogram = require("../../mini_histogram");
var _use_eui_theme = require("../../../hooks/use_eui_theme");
var _use_table_state = require("./use_table_state");
var _labels = require("./labels");
var _table_header = require("./table_header");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CategoryTable = ({
  categories,
  sparkLines,
  eventRate,
  dataViewId,
  selectedField,
  timefilter,
  aiopsListState,
  pinnedCategory,
  setPinnedCategory,
  selectedCategory,
  setSelectedCategory,
  onAddFilter,
  onClose = () => {},
  enableRowActions = true
}) => {
  const euiTheme = (0, _use_eui_theme.useEuiTheme)();
  const primaryBackgroundColor = (0, _eui.useEuiBackgroundColor)('primary');
  const {
    openInDiscoverWithFilter
  } = (0, _use_discover_links.useDiscoverLinks)();
  const [selectedCategories, setSelectedCategories] = (0, _react.useState)([]);
  const {
    onTableChange,
    pagination,
    sorting
  } = (0, _use_table_state.useTableState)(categories !== null && categories !== void 0 ? categories : [], 'key');
  const labels = (0, _react.useMemo)(() => (0, _labels.getLabels)(onAddFilter !== undefined && onClose !== undefined), [onAddFilter, onClose]);
  const openInDiscover = (mode, category) => {
    if (onAddFilter !== undefined && selectedField !== undefined && typeof selectedField !== 'string') {
      onAddFilter((0, _use_discover_links.createFilter)('', selectedField.name, selectedCategories, mode, category), `Patterns - ${selectedField.name}`);
      onClose();
      return;
    }
    const timefilterActiveBounds = timefilter.getActiveBounds();
    if (timefilterActiveBounds === undefined || selectedField === undefined) {
      return;
    }
    openInDiscoverWithFilter(dataViewId, typeof selectedField === 'string' ? selectedField : selectedField.name, selectedCategories, aiopsListState, timefilterActiveBounds, mode, category);
  };
  const columns = [{
    field: 'count',
    name: _i18n.i18n.translate('xpack.aiops.logCategorization.column.count', {
      defaultMessage: 'Count'
    }),
    sortable: true,
    width: '80px'
  }, {
    field: 'count',
    name: _i18n.i18n.translate('xpack.aiops.logCategorization.column.logRate', {
      defaultMessage: 'Log rate'
    }),
    sortable: false,
    width: '100px',
    render: (_, {
      key
    }) => {
      const sparkLine = sparkLines[key];
      if (sparkLine === undefined) {
        return null;
      }
      const histogram = eventRate.map(e => ({
        doc_count_overall: e.docCount,
        doc_count_significant_term: sparkLine[e.key],
        key: e.key,
        key_as_string: `${e.key}`
      }));
      return /*#__PURE__*/_react.default.createElement(_mini_histogram.MiniHistogram, {
        chartData: histogram,
        isLoading: categories === null && histogram === undefined,
        label: ''
      });
    }
  }, {
    field: 'examples',
    name: _i18n.i18n.translate('xpack.aiops.logCategorization.column.examples', {
      defaultMessage: 'Examples'
    }),
    sortable: true,
    render: examples => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, examples.map(e => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      key: e
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      language: "log",
      transparentBackground: true,
      css: {
        paddingInline: '0px'
      }
    }, e))))
  }, {
    name: _i18n.i18n.translate('xpack.aiops.logCategorization.column.actions', {
      defaultMessage: 'Actions'
    }),
    sortable: false,
    width: '60px',
    actions: [{
      name: labels.singleSelect.in,
      description: labels.singleSelect.in,
      icon: 'plusInCircle',
      type: 'icon',
      onClick: category => openInDiscover(_use_discover_links.QUERY_MODE.INCLUDE, category)
    }, {
      name: labels.singleSelect.out,
      description: labels.singleSelect.out,
      icon: 'minusInCircle',
      type: 'icon',
      onClick: category => openInDiscover(_use_discover_links.QUERY_MODE.EXCLUDE, category)
    }]
  }];
  const selectionValue = {
    selectable: () => true,
    onSelectionChange: selectedItems => setSelectedCategories(selectedItems)
  };
  const getRowStyle = category => {
    if (pinnedCategory && pinnedCategory.key === category.key && pinnedCategory.key === category.key) {
      return {
        backgroundColor: primaryBackgroundColor
      };
    }
    if (selectedCategory && selectedCategory.key === category.key) {
      return {
        backgroundColor: euiTheme.euiColorLightestShade
      };
    }
    return {
      backgroundColor: euiTheme.euiColorEmptyShade
    };
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_table_header.TableHeader, {
    categoriesCount: categories.length,
    selectedCategoriesCount: selectedCategories.length,
    labels: labels,
    openInDiscover: queryMode => openInDiscover(queryMode)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    compressed: true,
    items: categories,
    columns: columns,
    isSelectable: true,
    selection: selectionValue,
    itemId: "key",
    onTableChange: onTableChange,
    pagination: pagination,
    sorting: sorting,
    rowProps: category => {
      return enableRowActions ? {
        onClick: () => {
          if (category.key === (pinnedCategory === null || pinnedCategory === void 0 ? void 0 : pinnedCategory.key)) {
            setPinnedCategory(null);
          } else {
            setPinnedCategory(category);
          }
        },
        onMouseEnter: () => {
          setSelectedCategory(category);
        },
        onMouseLeave: () => {
          setSelectedCategory(null);
        },
        style: getRowStyle(category)
      } : undefined;
    }
  }));
};
exports.CategoryTable = CategoryTable;