"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentCountContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _document_count_chart = require("../document_count_chart");
var _total_count_header = require("../total_count_header");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const clearSelectionLabel = _i18n.i18n.translate('xpack.aiops.documentCountContent.clearSelectionAriaLabel', {
  defaultMessage: 'Clear selection'
});
const DocumentCountContent = ({
  brushSelectionUpdateHandler,
  clearSelectionHandler,
  documentCountStats,
  documentCountStatsSplit,
  documentCountStatsSplitLabel = '',
  totalCount,
  sampleProbability,
  windowParameters
}) => {
  var _documentCountStats$b, _documentCountStatsSp;
  const [isBrushCleared, setIsBrushCleared] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    setIsBrushCleared(windowParameters === undefined);
  }, [windowParameters]);
  const bucketTimestamps = Object.keys((_documentCountStats$b = documentCountStats === null || documentCountStats === void 0 ? void 0 : documentCountStats.buckets) !== null && _documentCountStats$b !== void 0 ? _documentCountStats$b : {}).map(time => +time);
  const splitBucketTimestamps = Object.keys((_documentCountStatsSp = documentCountStatsSplit === null || documentCountStatsSplit === void 0 ? void 0 : documentCountStatsSplit.buckets) !== null && _documentCountStatsSp !== void 0 ? _documentCountStatsSp : {}).map(time => +time);
  const timeRangeEarliest = Math.min(...[...bucketTimestamps, ...splitBucketTimestamps]);
  const timeRangeLatest = Math.max(...[...bucketTimestamps, ...splitBucketTimestamps]);
  if (documentCountStats === undefined || documentCountStats.buckets === undefined || timeRangeEarliest === undefined || timeRangeLatest === undefined) {
    return totalCount !== undefined ? /*#__PURE__*/_react.default.createElement(_total_count_header.TotalCountHeader, {
      totalCount: totalCount,
      sampleProbability: sampleProbability
    }) : null;
  }
  const chartPoints = Object.entries(documentCountStats.buckets).map(([time, value]) => ({
    time: +time,
    value
  }));
  let chartPointsSplit;
  if ((documentCountStatsSplit === null || documentCountStatsSplit === void 0 ? void 0 : documentCountStatsSplit.buckets) !== undefined) {
    chartPointsSplit = Object.entries(documentCountStatsSplit === null || documentCountStatsSplit === void 0 ? void 0 : documentCountStatsSplit.buckets).map(([time, value]) => ({
      time: +time,
      value
    }));
  }
  function brushSelectionUpdate(d, force) {
    if (!isBrushCleared || force) {
      brushSelectionUpdateHandler(d);
    }
    if (force) {
      setIsBrushCleared(false);
    }
  }
  function clearSelection() {
    setIsBrushCleared(true);
    clearSelectionHandler();
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_total_count_header.TotalCountHeader, {
    totalCount: totalCount,
    sampleProbability: sampleProbability
  })), !isBrushCleared && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: clearSelection,
    size: "xs",
    "data-test-subj": "aiopsClearSelectionBadge"
  }, clearSelectionLabel))), documentCountStats.interval !== undefined && /*#__PURE__*/_react.default.createElement(_document_count_chart.DocumentCountChart, {
    brushSelectionUpdateHandler: brushSelectionUpdate,
    chartPoints: chartPoints,
    chartPointsSplit: chartPointsSplit,
    timeRangeEarliest: timeRangeEarliest,
    timeRangeLatest: timeRangeLatest,
    interval: documentCountStats.interval,
    chartPointsSplitLabel: documentCountStatsSplitLabel,
    isBrushCleared: isBrushCleared
  }));
};
exports.DocumentCountContent = DocumentCountContent;