"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BrushBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _format = require("@elastic/eui/lib/services/format");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-ignore

const DATE_FORMAT = 'YYYY-MM-DD';
const TIME_FORMAT = 'HH:mm:ss';
const BrushBadge = ({
  label,
  marginLeft,
  timestampFrom,
  timestampTo,
  width
}) => {
  // If "from" and "to" are on the same day, we skip displaying the date twice.
  const dateFrom = (0, _format.formatDate)(timestampFrom, DATE_FORMAT);
  const dateTo = (0, _format.formatDate)(timestampTo, DATE_FORMAT);
  const timeFrom = (0, _format.formatDate)(timestampFrom, TIME_FORMAT);
  const timeTo = (0, _format.formatDate)(timestampTo, TIME_FORMAT);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: {
      position: 'absolute',
      marginLeft: `${marginLeft}px`
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, dateFrom, " ", timeFrom, " -", ' ', dateFrom !== dateTo && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("br", null), dateTo, ' '), timeTo),
    position: "top"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    css: {
      width,
      textAlign: 'center'
    }
  }, label)));
};
exports.BrushBadge = BrushBadge;