"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fnOperationTypeMapping = exports.SPLIT_FIELD_CARDINALITY_LIMIT = exports.MAX_CHANGE_POINT_CONFIGS = exports.EXCLUDED_CHANGE_POINT_TYPES = exports.DEFAULT_AGG_FUNCTION = exports.COMPOSITE_AGG_SIZE = exports.CHANGE_POINT_TYPES = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fnOperationTypeMapping = {
  avg: 'average',
  max: 'max',
  min: 'min',
  sum: 'sum'
};
exports.fnOperationTypeMapping = fnOperationTypeMapping;
const DEFAULT_AGG_FUNCTION = 'avg';
exports.DEFAULT_AGG_FUNCTION = DEFAULT_AGG_FUNCTION;
const SPLIT_FIELD_CARDINALITY_LIMIT = 10000;
exports.SPLIT_FIELD_CARDINALITY_LIMIT = SPLIT_FIELD_CARDINALITY_LIMIT;
const COMPOSITE_AGG_SIZE = 500;
exports.COMPOSITE_AGG_SIZE = COMPOSITE_AGG_SIZE;
const CHANGE_POINT_TYPES = {
  DIP: 'dip',
  SPIKE: 'spike',
  DISTRIBUTION_CHANGE: 'distribution_change',
  STEP_CHANGE: 'step_change',
  TREND_CHANGE: 'trend_change',
  STATIONARY: 'stationary',
  NON_STATIONARY: 'non_stationary',
  INDETERMINABLE: 'indeterminable'
};
exports.CHANGE_POINT_TYPES = CHANGE_POINT_TYPES;
const EXCLUDED_CHANGE_POINT_TYPES = new Set([CHANGE_POINT_TYPES.STATIONARY, CHANGE_POINT_TYPES.NON_STATIONARY, CHANGE_POINT_TYPES.INDETERMINABLE]);
exports.EXCLUDED_CHANGE_POINT_TYPES = EXCLUDED_CHANGE_POINT_TYPES;
const MAX_CHANGE_POINT_CONFIGS = 6;
exports.MAX_CHANGE_POINT_CONFIGS = MAX_CHANGE_POINT_CONFIGS;