"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartsGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _chart_component = require("./chart_component");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CHARTS_PER_PAGE = 6;
const ChartsGrid = ({
  changePoints: changePointsDict
}) => {
  const timefilter = (0, _mlDatePicker.useTimefilter)();
  const initialRefreshSetting = (0, _react.useRef)();
  (0, _react.useEffect)(function pauseRefreshOnMount() {
    initialRefreshSetting.current = timefilter.getRefreshInterval();
    timefilter.setRefreshInterval({
      ...initialRefreshSetting.current,
      pause: true
    });
    return () => {
      if (initialRefreshSetting.current) {
        // reset initial settings
        timefilter.setRefreshInterval(initialRefreshSetting.current);
      }
    };
  }, [timefilter]);
  const changePoints = (0, _react.useMemo)(() => {
    return Object.values(changePointsDict).flat();
  }, [changePointsDict]);
  const [activePage, setActivePage] = (0, _react.useState)(0);
  const resultPerPage = (0, _react.useMemo)(() => {
    const start = activePage * CHARTS_PER_PAGE;
    return changePoints.slice(start, start + CHARTS_PER_PAGE);
  }, [changePoints, activePage]);
  const pagination = (0, _react.useMemo)(() => {
    var _changePoints$length;
    return {
      activePage,
      pageCount: Math.ceil(((_changePoints$length = changePoints.length) !== null && _changePoints$length !== void 0 ? _changePoints$length : 0) / CHARTS_PER_PAGE),
      updatePagination: setActivePage
    };
  }, [activePage, changePoints.length]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: resultPerPage.length >= 2 ? 2 : 1,
    responsive: true,
    gutterSize: 'm'
  }, resultPerPage.map((v, index) => {
    var _v$group$value, _v$group;
    const key = `${index}_${(_v$group$value = (_v$group = v.group) === null || _v$group === void 0 ? void 0 : _v$group.value) !== null && _v$group$value !== void 0 ? _v$group$value : 'single_metric'}_${v.fn}_${v.metricField}_${v.timestamp}_${v.p_value}`;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: key
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      paddingSize: "s",
      hasBorder: true,
      hasShadow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: 'center',
      justifyContent: 'spaceBetween',
      gutterSize: 's'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, v.group ? /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      type: "inline",
      listItems: [{
        title: v.group.name,
        description: v.group.value
      }]
    }) : null, v.reason ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: v.reason
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      tabIndex: 0,
      color: 'warning',
      type: "warning",
      title: _i18n.i18n.translate('xpack.aiops.changePointDetection.notResultsWarning', {
        defaultMessage: 'No change point agg results warning'
      })
    })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: 'subdued',
      size: 's'
    }, v.fn, "(", v.metricField, ")"))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: 'spaceBetween',
      alignItems: 'center'
    }, v.p_value !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      type: "inline",
      listItems: [{
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.aiops.explainLogRateSpikes.spikeAnalysisTableGroups.pValueLabel",
          defaultMessage: "p-value"
        }),
        description: v.p_value.toPrecision(3)
      }]
    })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, v.type))), /*#__PURE__*/_react.default.createElement(_chart_component.ChartComponent, {
      fieldConfig: {
        splitField: v.splitField,
        fn: v.fn,
        metricField: v.metricField
      },
      annotation: v
    })));
  })), pagination.pageCount > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    pageCount: pagination.pageCount,
    activePage: pagination.activePage,
    onPageClick: pagination.updatePagination
  }))) : null);
};
exports.ChartsGrid = ChartsGrid;