"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangePointDetectionAppState = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _mlUrlState = require("@kbn/ml-url-state");
var _public = require("@kbn/kibana-utils-plugin/public");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _common = require("@kbn/data-plugin/common");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _use_data_source = require("../../hooks/use_data_source");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _storage = require("../../types/storage");
var _page_header = require("../page_header");
var _change_point_detection_page = require("./change_point_detection_page");
var _change_point_detection_context = require("./change_point_detection_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const localStorage = new _public.Storage(window.localStorage);
const ChangePointDetectionAppState = ({
  dataView,
  savedSearch,
  appDependencies
}) => {
  const datePickerDeps = {
    ...(0, _lodash.pick)(appDependencies, ['data', 'http', 'notifications', 'theme', 'uiSettings']),
    toMountPoint: _public2.toMountPoint,
    wrapWithTheme: _public2.wrapWithTheme,
    uiSettingsKeys: _common.UI_SETTINGS
  };
  if (!dataView.isTimeBased()) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.aiops.index.dataViewNotBasedOnTimeSeriesNotificationTitle', {
        defaultMessage: 'The data view "{dataViewTitle}" is not based on a time series.',
        values: {
          dataViewTitle: dataView.getName()
        }
      }),
      color: "danger",
      iconType: "warning"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.aiops.index.changePointTimeSeriesNotificationDescription', {
      defaultMessage: 'Change point detection only runs over time-based indices.'
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_use_aiops_app_context.AiopsAppContext.Provider, {
    value: appDependencies
  }, /*#__PURE__*/_react.default.createElement(_mlUrlState.UrlStateProvider, null, /*#__PURE__*/_react.default.createElement(_use_data_source.DataSourceContext.Provider, {
    value: {
      dataView,
      savedSearch
    }
  }, /*#__PURE__*/_react.default.createElement(_mlLocalStorage.StorageContextProvider, {
    storage: localStorage,
    storageKeys: _storage.AIOPS_STORAGE_KEYS
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, datePickerDeps, /*#__PURE__*/_react.default.createElement(_page_header.PageHeader, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_change_point_detection_context.ChangePointDetectionContextProvider, null, /*#__PURE__*/_react.default.createElement(_change_point_detection_page.ChangePointDetectionPage, null)))))));
};
exports.ChangePointDetectionAppState = ChangePointDetectionAppState;