"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangePointDetectionPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _charts_grid = require("./charts_grid");
var _fields_config = require("./fields_config");
var _use_data_source = require("../../hooks/use_data_source");
var _change_point_type_filter = require("./change_point_type_filter");
var _search_bar = require("./search_bar");
var _change_point_detection_context = require("./change_point_detection_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChangePointDetectionPage = () => {
  const [isFlyoutVisible, setFlyoutVisible] = (0, _react.useState)(false);
  const {
    requestParams,
    updateRequestParams,
    resultFilters,
    updateFilters,
    resultQuery,
    metricFieldOptions,
    selectedChangePoints
  } = (0, _change_point_detection_context.useChangePointDetectionContext)();
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const setQuery = (0, _react.useCallback)(query => {
    updateRequestParams({
      query
    });
  }, [updateRequestParams]);
  const setChangePointType = (0, _react.useCallback)(changePointType => {
    updateRequestParams({
      changePointType
    });
  }, [updateRequestParams]);
  if (metricFieldOptions.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.aiops.index.dataViewWithoutMetricNotificationTitle', {
        defaultMessage: 'The data view "{dataViewTitle}" does not contain any metric fields.',
        values: {
          dataViewTitle: dataView.getName()
        }
      }),
      color: "danger",
      iconType: "warning"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.aiops.index.dataViewWithoutMetricNotificationDescription', {
      defaultMessage: 'Change point detection can only be run on data views with a metric field.'
    })));
  }
  const hasSelectedChangePoints = Object.values(selectedChangePoints).some(v => v.length > 0);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "aiopsChangePointDetectionPage"
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBarWrapper, {
    query: resultQuery,
    onQueryChange: setQuery,
    filters: resultFilters,
    onFiltersChange: updateFilters
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: 'center',
    justifyContent: 'spaceBetween'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: 'center'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 's'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.changePointDetection.aggregationIntervalTitle",
    defaultMessage: "Aggregation interval: "
  }), requestParams.interval)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: hasSelectedChangePoints ? '' : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.changePointDetection.viewSelectedChartsToltip",
      defaultMessage: "Select change points to view them in detail."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setFlyoutVisible(!isFlyoutVisible),
    size: 's',
    disabled: !hasSelectedChangePoints
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.changePointDetection.viewSelectedButtonLabel",
    defaultMessage: "View selected"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: '400px'
    }
  }, /*#__PURE__*/_react.default.createElement(_change_point_type_filter.ChangePointTypeFilter, {
    value: requestParams.changePointType,
    onChange: setChangePointType
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_fields_config.FieldsConfig, null), isFlyoutVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: setFlyoutVisible.bind(null, false),
    "aria-labelledby": 'change_point_charts',
    size: 'l'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: 'change_point_charts'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.changePointDetection.selectedChangePointsHeader",
    defaultMessage: "Selected change points"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_charts_grid.ChartsGrid, {
    changePoints: selectedChangePoints
  }))) : null);
};
exports.ChangePointDetectionPage = ChangePointDetectionPage;