"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildExtendedBaseFilterCriteria = buildExtendedBaseFilterCriteria;
var _mlQueryUtils = require("@kbn/ml-query-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO Consolidate with duplicate query utils in
// `x-pack/plugins/data_visualizer/common/utils/query_utils.ts`

/*
 * Contains utility functions for building and processing queries.
 */

// Builds the base filter criteria used in queries,
// adding criteria for the time range and an optional query.
function buildExtendedBaseFilterCriteria(timeFieldName, earliestMs, latestMs, query, selectedSignificantTerm, includeSelectedSignificantTerm = true, selectedGroup) {
  const filterCriteria = (0, _mlQueryUtils.buildBaseFilterCriteria)(timeFieldName, earliestMs, latestMs, query);
  const groupFilter = [];
  if (selectedGroup) {
    const allItems = selectedGroup.groupItemsSortedByUniqueness;
    for (const item of allItems) {
      const {
        fieldName,
        fieldValue
      } = item;
      groupFilter.push({
        term: {
          [fieldName]: fieldValue
        }
      });
    }
  }
  if (includeSelectedSignificantTerm) {
    if (selectedSignificantTerm) {
      filterCriteria.push({
        term: {
          [selectedSignificantTerm.fieldName]: selectedSignificantTerm.fieldValue
        }
      });
    } else if (selectedGroup) {
      filterCriteria.push(...groupFilter);
    }
  } else if (selectedSignificantTerm && !includeSelectedSignificantTerm) {
    filterCriteria.push({
      bool: {
        must_not: [{
          term: {
            [selectedSignificantTerm.fieldName]: selectedSignificantTerm.fieldValue
          }
        }]
      }
    });
  } else if (selectedGroup && !includeSelectedSignificantTerm) {
    filterCriteria.push({
      bool: {
        must_not: [{
          bool: {
            filter: [...groupFilter]
          }
        }]
      }
    });
  }
  return filterCriteria;
}