"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.API_ACTION_NAME = void 0;
exports.addErrorAction = addErrorAction;
exports.addSignificantTermsAction = addSignificantTermsAction;
exports.addSignificantTermsGroupAction = addSignificantTermsGroupAction;
exports.addSignificantTermsGroupHistogramAction = addSignificantTermsGroupHistogramAction;
exports.addSignificantTermsHistogramAction = addSignificantTermsHistogramAction;
exports.pingAction = pingAction;
exports.resetAllAction = resetAllAction;
exports.resetErrorsAction = resetErrorsAction;
exports.resetGroupsAction = resetGroupsAction;
exports.updateLoadingStateAction = updateLoadingStateAction;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_ACTION_NAME = {
  ADD_SIGNIFICANT_TERMS: 'add_significant_terms',
  ADD_SIGNIFICANT_TERMS_HISTOGRAM: 'add_significant_terms_histogram',
  ADD_SIGNIFICANT_TERMS_GROUP: 'add_significant_terms_group',
  ADD_SIGNIFICANT_TERMS_GROUP_HISTOGRAM: 'add_significant_terms_group_histogram',
  ADD_ERROR: 'add_error',
  PING: 'ping',
  RESET_ALL: 'reset_all',
  RESET_ERRORS: 'reset_errors',
  RESET_GROUPS: 'reset_groups',
  UPDATE_LOADING_STATE: 'update_loading_state'
};
exports.API_ACTION_NAME = API_ACTION_NAME;
function addSignificantTermsAction(payload) {
  return {
    type: API_ACTION_NAME.ADD_SIGNIFICANT_TERMS,
    payload
  };
}
function addSignificantTermsHistogramAction(payload) {
  return {
    type: API_ACTION_NAME.ADD_SIGNIFICANT_TERMS_HISTOGRAM,
    payload
  };
}
function addSignificantTermsGroupAction(payload) {
  return {
    type: API_ACTION_NAME.ADD_SIGNIFICANT_TERMS_GROUP,
    payload
  };
}
function addSignificantTermsGroupHistogramAction(payload) {
  return {
    type: API_ACTION_NAME.ADD_SIGNIFICANT_TERMS_GROUP_HISTOGRAM,
    payload
  };
}
function addErrorAction(payload) {
  return {
    type: API_ACTION_NAME.ADD_ERROR,
    payload
  };
}
function resetErrorsAction() {
  return {
    type: API_ACTION_NAME.RESET_ERRORS
  };
}
function pingAction() {
  return {
    type: API_ACTION_NAME.PING
  };
}
function resetAllAction() {
  return {
    type: API_ACTION_NAME.RESET_ALL
  };
}
function resetGroupsAction() {
  return {
    type: API_ACTION_NAME.RESET_GROUPS
  };
}
function updateLoadingStateAction(payload) {
  return {
    type: API_ACTION_NAME.UPDATE_LOADING_STATE,
    payload
  };
}