"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Settings = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _useEffectOnce = _interopRequireDefault(require("react-use/lib/useEffectOnce"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-utils-plugin/common");
var _queryString = require("query-string");
var _settings_helper = require("./settings_helper");
var _search = require("./components/search/search");
var _advanced_settings = require("./advanced_settings");
var _search2 = require("./components/search");
var _i18n_texts = require("./i18n_texts");
var _lib = require("./lib");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SPACE_SETTINGS_ID = 'space-settings';
const GLOBAL_SETTINGS_ID = 'global-settings';
const Settings = props => {
  var _tabs$find;
  const {
    componentRegistry,
    history,
    settingsService,
    enableSaving,
    enableShowing,
    ...rest
  } = props;
  const uiSettings = settingsService.client;
  const globalUiSettings = settingsService.globalClient;
  const [settings, setSettings] = (0, _react.useState)((0, _settings_helper.mapConfig)(uiSettings));
  const [globalSettings, setGlobalSettings] = (0, _react.useState)((0, _settings_helper.mapConfig)(globalUiSettings));
  const [groupedSettings, setGroupedSettings] = (0, _react.useState)({
    namespace: (0, _settings_helper.mapSettings)(settings),
    global: (0, _settings_helper.mapSettings)(globalSettings)
  });
  const [categoryCounts, setCategoryCounts] = (0, _react.useState)({
    namespace: (0, _settings_helper.initCategoryCounts)(groupedSettings.namespace),
    global: (0, _settings_helper.initCategoryCounts)(groupedSettings.global)
  });
  const [categories, setCategories] = (0, _react.useState)({
    namespace: (0, _settings_helper.initCategories)(groupedSettings.namespace),
    global: (0, _settings_helper.initCategories)(groupedSettings.global)
  });
  const [queryState, setQueryState] = (0, _react.useState)({
    filteredSettings: {
      global: {},
      namespace: {}
    },
    footerQueryMatched: false,
    query: _eui.Query.parse('')
  });
  const setTimeoutCallback = () => {
    var _document$getElementB;
    const {
      hash
    } = window.location;
    const id = hash.replace('#', '');
    const element = document.getElementById(id);
    let globalNavOffset = 0;
    const globalNavBars = (_document$getElementB = document.getElementById('globalHeaderBars')) === null || _document$getElementB === void 0 ? void 0 : _document$getElementB.getElementsByClassName('euiHeader');
    if (globalNavBars) {
      Array.from(globalNavBars).forEach(navBar => {
        globalNavOffset += navBar.offsetHeight;
      });
    }
    if (element) {
      element.scrollIntoView();
      window.scrollBy(0, -globalNavOffset); // offsets scroll by height of the global nav
    }
  };

  (0, _useEffectOnce.default)(() => {
    setQueryState(getQueryState(undefined, true));
    const subscription = (mappedSettings, scope) => {
      const grouped = {
        ...groupedSettings
      };
      grouped[scope] = (0, _settings_helper.mapSettings)(mappedSettings);
      setGroupedSettings(grouped);
      const updatedCategories = {
        ...categories
      };
      updatedCategories[scope] = (0, _settings_helper.initCategories)(groupedSettings[scope]);
      setCategories(updatedCategories);
      const updatedCategoryCounts = {
        ...categoryCounts
      };
      updatedCategoryCounts[scope] = (0, _settings_helper.initCategoryCounts)(groupedSettings[scope]);
      setCategoryCounts(updatedCategoryCounts);
      const updatedQueryState = {
        ...getQueryState(undefined, true)
      };
      updatedQueryState.filteredSettings[scope] = (0, _settings_helper.mapSettings)(_eui.Query.execute(updatedQueryState.query, mappedSettings));
      setQueryState(updatedQueryState);
    };
    const uiSettingsSubscription = uiSettings.getUpdate$().subscribe(() => {
      const updatedSettings = (0, _settings_helper.mapConfig)(uiSettings);
      setSettings(updatedSettings);
      subscription(updatedSettings, 'namespace');
    });
    const globalUiSettingsSubscription = globalUiSettings.getUpdate$().subscribe(() => {
      const mappedSettings = (0, _settings_helper.mapConfig)(globalUiSettings);
      setGlobalSettings(mappedSettings);
      subscription(mappedSettings, 'global');
    });
    if (window.location.hash !== '') {
      setTimeout(() => setTimeoutCallback(), 0);
    }
    const unregister = history.listen(({
      search
    }) => {
      setQueryState(getQueryState(search));
    });
    return () => {
      unregister();
      uiSettingsSubscription.unsubscribe();
      globalUiSettingsSubscription.unsubscribe();
    };
  });
  const setUrlQuery = (0, _react.useCallback)((query = '') => {
    const search = _common.url.addQueryParam(window.location.search, _advanced_settings.QUERY, query);
    history.push({
      pathname: '',
      // remove any route query param
      search
    });
  }, [history]);
  const searchCategories = (0, _react.useMemo)(() => {
    return categories.global.concat(categories.namespace);
  }, [categories.global, categories.namespace]);
  const callOutTitle = scope => {
    if (scope === 'namespace') {
      return _i18n_texts.i18nTexts.defaultSpaceCalloutTitle;
    }
    return _i18n_texts.i18nTexts.globalCalloutTitle;
  };
  const callOutSubtitle = scope => {
    if (scope === 'namespace') {
      return _i18n_texts.i18nTexts.defaultSpaceCalloutSubtitle;
    }
    return _i18n_texts.i18nTexts.globalCalloutSubtitle;
  };
  const getClientForScope = scope => {
    if (scope === 'namespace') {
      return uiSettings;
    }
    return globalUiSettings;
  };
  const renderAdvancedSettings = scope => {
    return /*#__PURE__*/_react.default.createElement(_advanced_settings.AdvancedSettings, (0, _extends2.default)({
      groupedSettings: groupedSettings[scope],
      categoryCounts: categoryCounts[scope],
      categories: categories[scope],
      visibleSettings: queryState.filteredSettings[scope],
      clearQuery: () => setUrlQuery(''),
      noResults: !queryState.footerQueryMatched,
      queryText: queryState.query.text,
      callOutTitle: callOutTitle(scope),
      callOutSubtitle: callOutSubtitle(scope),
      settingsService: settingsService,
      uiSettingsClient: getClientForScope(scope),
      enableSaving: enableSaving[scope]
    }, rest));
  };
  const tabs = [{
    id: SPACE_SETTINGS_ID,
    name: _i18n_texts.i18nTexts.defaultSpaceTabTitle,
    append: queryState.query.text !== '' ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      className: "eui-alignCenter",
      size: "m",
      key: "spaceSettings-badge"
    }, Object.keys(queryState.filteredSettings.namespace).length) : null,
    content: renderAdvancedSettings('namespace')
  }];
  if (enableShowing.global) {
    tabs.push({
      id: GLOBAL_SETTINGS_ID,
      name: _i18n_texts.i18nTexts.globalTabTitle,
      append: queryState.query.text !== '' ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        className: "eui-alignCenter",
        size: "m",
        key: "spaceSettings-badge"
      }, Object.keys(queryState.filteredSettings.global).length + Number(queryState.footerQueryMatched)) : null,
      content: renderAdvancedSettings('global')
    });
  }
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(SPACE_SETTINGS_ID);
  const selectedTabContent = (_tabs$find = tabs.find(obj => obj.id === selectedTabId)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content;
  const onSelectedTabChanged = id => {
    setSelectedTabId(id);
  };
  const renderTabs = () => {
    return tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      key: index,
      "data-test-subj": `advancedSettingsTab-${tab.id}`,
      onClick: () => onSelectedTabChanged(tab.id),
      isSelected: tab.id === selectedTabId,
      append: tab.append
    }, tab.name));
  };
  const getQuery = (queryString, initialQuery = false) => {
    try {
      const query = initialQuery ? (0, _lib.getAriaName)(queryString) : queryString !== null && queryString !== void 0 ? queryString : '';
      return _eui.Query.parse(query);
    } catch ({
      message
    }) {
      props.toasts.addWarning({
        title: _search.parseErrorMsg,
        text: message
      });
      return _eui.Query.parse('');
    }
  };
  const getQueryText = search => {
    var _parse, _ref;
    const queryParams = (_parse = (0, _queryString.parse)(search !== null && search !== void 0 ? search : window.location.search)) !== null && _parse !== void 0 ? _parse : {};
    return (_ref = queryParams[_advanced_settings.QUERY]) !== null && _ref !== void 0 ? _ref : '';
  };
  const getQueryState = (search, initialQuery = false) => {
    const queryString = getQueryText(search);
    const query = getQuery(queryString, initialQuery);
    const filteredSettings = {
      namespace: (0, _settings_helper.mapSettings)(_eui.Query.execute(query, settings)),
      global: (0, _settings_helper.mapSettings)(_eui.Query.execute(query, globalSettings))
    };
    return {
      query,
      filteredSettings,
      footerQueryMatched: initialQuery ? false : queryState.footerQueryMatched
    };
  };
  const onQueryChange = (0, _react.useCallback)(({
    query
  }) => {
    setUrlQuery(query.text);
  }, [setUrlQuery]);
  const onFooterQueryMatchChange = (0, _react.useCallback)(matched => {
    setQueryState({
      ...queryState,
      footerQueryMatched: matched
    });
  }, [queryState]);
  const PageTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", {
    "data-test-subj": "managementSettingsTitle"
  }, _i18n_texts.i18nTexts.advancedSettingsTitle));
  const PageFooter = componentRegistry.get(componentRegistry.componentType.PAGE_FOOTER_COMPONENT);
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, PageTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_search2.Search, {
    query: queryState.query,
    categories: searchCategories,
    onQueryChange: onQueryChange
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, renderTabs()), selectedTabContent, selectedTabId === GLOBAL_SETTINGS_ID ? /*#__PURE__*/_react.default.createElement(PageFooter, {
    toasts: props.toasts,
    query: queryState.query,
    onQueryMatchChange: onFooterQueryMatchChange,
    enableSaving: props.enableSaving
  }) : null);
};
exports.Settings = Settings;