"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountManagementSection = mountManagementSection;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _advanced_settings = require("./advanced_settings");
var _settings = require("./settings");
require("./index.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const title = _i18n.i18n.translate('advancedSettings.advancedSettingsLabel', {
  defaultMessage: 'Advanced Settings'
});
const crumb = [{
  text: title
}];
const readOnlyBadge = {
  text: _i18n.i18n.translate('advancedSettings.badge.readOnly.text', {
    defaultMessage: 'Read only'
  }),
  tooltip: _i18n.i18n.translate('advancedSettings.badge.readOnly.tooltip', {
    defaultMessage: 'Unable to save advanced settings'
  }),
  iconType: 'glasses'
};
const redirectUrl = ({
  match,
  location
}) => {
  const search = _public2.url.addQueryParam(location.search, _advanced_settings.QUERY, match === null || match === void 0 ? void 0 : match.params[_advanced_settings.QUERY]);
  return {
    pathname: '/',
    search
  };
};
async function mountManagementSection(getStartServices, params, componentRegistry, usageCollection) {
  params.setBreadcrumbs(crumb);
  const [{
    settings,
    notifications,
    docLinks,
    application,
    chrome
  }] = await getStartServices();
  const {
    advancedSettings,
    globalSettings
  } = application.capabilities;
  const canSaveAdvancedSettings = advancedSettings.save;
  const canSaveGlobalSettings = globalSettings.save;
  const canShowGlobalSettings = globalSettings.show;
  const trackUiMetric = usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiCounter.bind(usageCollection, 'advanced_settings');
  if (!canSaveAdvancedSettings || !canSaveGlobalSettings && canShowGlobalSettings) {
    chrome.setBadge(readOnlyBadge);
  }
  chrome.docTitle.change(title);
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: params.theme$
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
    history: params.history
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/:${_advanced_settings.QUERY}`
  }, props => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: redirectUrl(props)
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/"
  }, /*#__PURE__*/_react.default.createElement(_settings.Settings, {
    history: params.history,
    enableSaving: {
      namespace: canSaveAdvancedSettings,
      global: canSaveGlobalSettings
    },
    enableShowing: {
      namespace: true,
      global: canShowGlobalSettings
    },
    toasts: notifications.toasts,
    docLinks: docLinks.links,
    settingsService: settings,
    theme: params.theme$,
    componentRegistry: componentRegistry,
    trackUiMetric: trackUiMetric
  })))))), params.element);
  return () => {
    chrome.docTitle.reset();
    _reactDom.default.unmountComponentAtNode(params.element);
  };
}