"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toEditableConfig = toEditableConfig;
var _get_val_type = require("./get_val_type");
var _get_aria_name = require("./get_aria_name");
var _default_category = require("./default_category");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * @param {object} advanced setting definition object
 * @param {object} name of setting
 * @param {object} current value of setting
 * @returns {object} the editable config object
 */
function toEditableConfig({
  def,
  name,
  value,
  isCustom,
  isOverridden
}) {
  if (!def) {
    def = {};
  }
  const conf = {
    name,
    displayName: def.name || name,
    ariaName: def.name || (0, _get_aria_name.getAriaName)(name),
    value,
    category: def.category && def.category.length ? def.category : [_default_category.DEFAULT_CATEGORY],
    isCustom,
    isOverridden,
    readOnly: !!def.readonly,
    defVal: def.value,
    type: (0, _get_val_type.getValType)(def, value),
    description: def.description,
    deprecation: def.deprecation,
    options: def.options,
    optionLabels: def.optionLabels,
    order: def.order,
    requiresPageReload: !!def.requiresPageReload,
    metric: def.metric
  };
  return conf;
}