"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCategoryName = getCategoryName;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const upperFirst = (str = '') => str.replace(/^./, strng => strng.toUpperCase());
const names = {
  general: _i18n.i18n.translate('advancedSettings.categoryNames.generalLabel', {
    defaultMessage: 'General'
  }),
  machineLearning: _i18n.i18n.translate('advancedSettings.categoryNames.machineLearningLabel', {
    defaultMessage: 'Machine Learning'
  }),
  observability: _i18n.i18n.translate('advancedSettings.categoryNames.observabilityLabel', {
    defaultMessage: 'Observability'
  }),
  timelion: _i18n.i18n.translate('advancedSettings.categoryNames.timelionLabel', {
    defaultMessage: 'Timelion'
  }),
  notifications: _i18n.i18n.translate('advancedSettings.categoryNames.notificationsLabel', {
    defaultMessage: 'Notifications'
  }),
  visualizations: _i18n.i18n.translate('advancedSettings.categoryNames.visualizationsLabel', {
    defaultMessage: 'Visualizations'
  }),
  discover: _i18n.i18n.translate('advancedSettings.categoryNames.discoverLabel', {
    defaultMessage: 'Discover'
  }),
  dashboard: _i18n.i18n.translate('advancedSettings.categoryNames.dashboardLabel', {
    defaultMessage: 'Dashboard'
  }),
  reporting: _i18n.i18n.translate('advancedSettings.categoryNames.reportingLabel', {
    defaultMessage: 'Reporting'
  }),
  search: _i18n.i18n.translate('advancedSettings.categoryNames.searchLabel', {
    defaultMessage: 'Search'
  }),
  securitySolution: _i18n.i18n.translate('advancedSettings.categoryNames.securitySolutionLabel', {
    defaultMessage: 'Security Solution'
  }),
  enterpriseSearch: _i18n.i18n.translate('advancedSettings.categoryNames.enterpriseSearchLabel', {
    defaultMessage: 'Enterprise Search'
  })
};
function getCategoryName(category) {
  return category ? names[category] || upperFirst(category) : '';
}