"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QUERY = exports.AdvancedSettings = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _advanced_settings_voice_announcement = require("./components/advanced_settings_voice_announcement");
var _form = require("./components/form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const QUERY = 'query';
exports.QUERY = QUERY;
class AdvancedSettings extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "saveConfig", async changes => {
      const arr = Object.entries(changes).map(([key, value]) => this.props.uiSettingsClient.set(key, value));
      return Promise.all(arr);
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xl"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: this.props.callOutTitle,
      iconType: "warning"
    }, /*#__PURE__*/_react.default.createElement("p", null, this.props.callOutSubtitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xl"
    }), /*#__PURE__*/_react.default.createElement(_advanced_settings_voice_announcement.AdvancedSettingsVoiceAnnouncement, {
      queryText: this.props.queryText,
      settings: this.props.visibleSettings
    }), /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        uiSettings: this.props.settingsService.client,
        settings: this.props.settingsService
      }
    }, /*#__PURE__*/_react.default.createElement(_form.Form, {
      settings: this.props.groupedSettings,
      visibleSettings: this.props.visibleSettings,
      categories: this.props.categories,
      categoryCounts: this.props.categoryCounts,
      clearQuery: this.props.clearQuery,
      save: this.saveConfig,
      showNoResultsMessage: this.props.noResults,
      enableSaving: this.props.enableSaving,
      docLinks: this.props.docLinks,
      toasts: this.props.toasts,
      trackUiMetric: this.props.trackUiMetric,
      queryText: this.props.queryText,
      theme: this.props.theme
    })));
  }
}
exports.AdvancedSettings = AdvancedSettings;