"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiGlobalStyles = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _mixins = require("../mixins");
var _functions = require("../functions");
var _color = require("../../services/color");
var _theme = require("../../services/theme");
var _reset = require("./reset");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _objectDestructuringEmpty(obj) { if (obj == null) throw new TypeError("Cannot destructure " + obj); }
var EuiGlobalStyles = function EuiGlobalStyles(_ref) {
  _objectDestructuringEmpty(_ref);
  var euiThemeContext = (0, _theme.useEuiTheme)();
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var base = euiTheme.base,
    colors = euiTheme.colors,
    font = euiTheme.font;

  /**
   * Declaring the top level scrollbar colors to match the theme also requires setting the sizes on Chrome
   * so that it knows to use custom styles. Therefore, we just reuse the same scrollbar mixin with thick size.
   */
  var scrollbarStyles = (0, _mixins.euiScrollBarStyles)(euiThemeContext, {
    trackColor: colorMode === 'LIGHT' ? (0, _color.shade)(colors.body, 0.03) : (0, _color.tint)(colors.body, 0.07),
    width: 'auto'
  });

  /**
   * This font reset sets all our base font/typography related properties
   * that are needed to override browser-specific element settings.
   */
  var fontReset = "\n    font-family: ".concat(font.family, ";\n    font-size: ", "".concat(font.scale[font.body.scale] * base, "px"), ";\n    line-height: ").concat(base / (font.scale[font.body.scale] * base), ";\n    font-weight: ").concat(font.weight[font.body.weight], ";\n  ");

  /**
   * Final styles
   */
  var styles = /*#__PURE__*/(0, _react2.css)(_reset.resetStyles, " html{", scrollbarStyles, " ", fontReset, " text-size-adjust:100%;font-kerning:normal;", (0, _functions.logicalCSS)('height', '100%'), " background-color:", colors.body, ";color:", colors.text, ";}code,pre,kbd,samp{font-family:", font.familyCode, ";}input,textarea,select{", fontReset, ";}button{font-family:", font.family, ";}em{font-style:italic;}strong{font-weight:", font.weight.bold, ";}*:focus{", (0, _mixins.euiFocusRing)(euiThemeContext), ";}::selection{background:", (0, _color.transparentize)(colors.primary, colorMode === 'LIGHT' ? 0.1 : 0.2), ";}a{color:", colors.primaryText, ";&,&:hover,&:focus{text-decoration:none;}}.euiBody-hasPortalContent{position:relative;};label:styles;");
  return (0, _react2.jsx)(_react2.Global, {
    styles: styles
  });
};
exports.EuiGlobalStyles = EuiGlobalStyles;