"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiYScrollWithShadows = exports.useEuiYScroll = exports.useEuiXScrollWithShadows = exports.useEuiXScroll = exports.useEuiScrollBar = exports.useEuiOverflowScroll = exports.euiYScrollWithShadows = exports.euiYScroll = exports.euiXScrollWithShadows = exports.euiXScroll = exports.euiSupportsHas = exports.euiScrollBarStyles = exports.euiOverflowScroll = exports.euiFullHeight = void 0;
var _theme = require("../../services/theme");
var _color = require("../../services/color");
var _functions = require("../functions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiScrollBarStyles = function euiScrollBarStyles(_ref) {
  var _ref$euiTheme = _ref.euiTheme,
    colors = _ref$euiTheme.colors,
    size = _ref$euiTheme.size;
  var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    _thumbColor = _ref2.thumbColor,
    _ref2$trackColor = _ref2.trackColor,
    trackColor = _ref2$trackColor === void 0 ? 'transparent' : _ref2$trackColor,
    _ref2$width = _ref2.width,
    width = _ref2$width === void 0 ? 'thin' : _ref2$width,
    _size = _ref2.size,
    _corner = _ref2.corner;
  // Set defaults from theme
  var thumbColor = _thumbColor || (0, _color.transparentize)(colors.darkShade, 0.5);
  var scrollBarSize = _size || size.base;
  var scrollBarCorner = _corner || width === 'thin' ? "calc(".concat(size.s, " * 0.75)") : size.xs;

  // Firefox's scrollbar coloring cascades, but the sizing does not,
  // so it's being added to this mixin for allowing support wherever custom scrollbars are
  var firefoxSupport = "scrollbar-color: ".concat(thumbColor, " ").concat(trackColor, ";");
  return "scrollbar-width: ".concat(width, ";\n\n    &::-webkit-scrollbar {\n      ").concat((0, _functions.logicalCSS)('width', scrollBarSize), "\n      ").concat((0, _functions.logicalCSS)('height', scrollBarSize), "\n    }\n\n    &::-webkit-scrollbar-thumb {\n      background-color: ").concat(thumbColor, ";\n      background-clip: content-box;\n      border-radius: ").concat(scrollBarSize, ";\n      border: ").concat(scrollBarCorner, " solid ").concat(trackColor, ";\n    }\n\n    &::-webkit-scrollbar-corner,\n    &::-webkit-scrollbar-track {\n      background-color: ").concat(trackColor, ";\n    }\n\n    ").concat(firefoxSupport, "\n  ");
};
exports.euiScrollBarStyles = euiScrollBarStyles;
var useEuiScrollBar = function useEuiScrollBar(options) {
  var euiTheme = (0, _theme.useEuiTheme)();
  return euiScrollBarStyles(euiTheme, options);
};

/**
 * *INTERNAL*
 * Overflow shadow masks for use in YScroll and XScroll helpers
 */
exports.useEuiScrollBar = useEuiScrollBar;
var euiOverflowShadowStyles = function euiOverflowShadowStyles(_ref3) {
  var size = _ref3.euiTheme.size;
  var _ref4 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    _direction = _ref4.direction,
    _side = _ref4.side;
  var direction = _direction || 'y';
  var side = _side || 'both';
  var hideHeight = size.s;
  var gradientStart = "\n  ".concat((0, _color.transparentize)('red', 0.1), " 0%,\n  ").concat((0, _color.transparentize)('red', 1), " ").concat(hideHeight, "\n  ");
  var gradientEnd = "\n  ".concat((0, _color.transparentize)('red', 1), " calc(100% - ").concat(hideHeight, "),\n  ").concat((0, _color.transparentize)('red', 0.1), " 100%\n  ");
  var gradient = '';
  if (side) {
    if (side === 'both') {
      gradient = "".concat(gradientStart, ", ").concat(gradientEnd);
    } else if (side === 'start') {
      gradient = "".concat(gradientStart);
    } else {
      gradient = "".concat(gradientEnd);
    }
  }
  if (direction === 'y') {
    return "mask-image: linear-gradient(to bottom, ".concat(gradient, ");");
  } else {
    return "mask-image: linear-gradient(to right, ".concat(gradient, ");");
  }
};

/**
 * 1. Focus rings shouldn't be visible on scrollable regions, but a11y requires them to be focusable.
 *    Browser's supporting `:focus-visible` will still show outline on keyboard focus only.
 *    Others like Safari, won't show anything at all.
 */

var euiYScroll = function euiYScroll(euiTheme) {
  var _ref5 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    height = _ref5.height;
  return "\n  ".concat(euiScrollBarStyles(euiTheme), "\n  ").concat((0, _functions.logicalCSS)('height', height || '100%'), "\n  ").concat((0, _functions.logicalCSSWithFallback)('overflow-y', 'auto'), "\n  ").concat((0, _functions.logicalCSSWithFallback)('overflow-x', 'hidden'), "\n  &:focus {\n    outline: none; /* 1 */\n  }\n");
};
exports.euiYScroll = euiYScroll;
var useEuiYScroll = function useEuiYScroll() {
  var _ref6 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
    height = _ref6.height;
  var euiTheme = (0, _theme.useEuiTheme)();
  return euiYScroll(euiTheme, {
    height: height
  });
};
exports.useEuiYScroll = useEuiYScroll;
var euiYScrollWithShadows = function euiYScrollWithShadows(euiTheme) {
  var _ref7 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    height = _ref7.height,
    _ref7$side = _ref7.side,
    side = _ref7$side === void 0 ? 'both' : _ref7$side;
  return "\n  ".concat(euiYScroll(euiTheme, {
    height: height
  }), "\n  ").concat(euiOverflowShadowStyles(euiTheme, {
    direction: 'y',
    side: side
  }), "\n");
};
exports.euiYScrollWithShadows = euiYScrollWithShadows;
var useEuiYScrollWithShadows = function useEuiYScrollWithShadows() {
  var _ref8 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
    height = _ref8.height;
  var euiTheme = (0, _theme.useEuiTheme)();
  return euiYScrollWithShadows(euiTheme, {
    height: height
  });
};
exports.useEuiYScrollWithShadows = useEuiYScrollWithShadows;
var euiXScroll = function euiXScroll(euiTheme) {
  return "\n  ".concat(euiScrollBarStyles(euiTheme), "\n  ").concat((0, _functions.logicalCSSWithFallback)('overflow-x', 'auto'), "\n  &:focus {\n    outline: none; /* 1 */\n  }\n");
};
exports.euiXScroll = euiXScroll;
var useEuiXScroll = function useEuiXScroll() {
  var euiTheme = (0, _theme.useEuiTheme)();
  return euiXScroll(euiTheme);
};
exports.useEuiXScroll = useEuiXScroll;
var euiXScrollWithShadows = function euiXScrollWithShadows(euiTheme) {
  return "\n  ".concat(euiXScroll(euiTheme), "\n  ").concat(euiOverflowShadowStyles(euiTheme, {
    direction: 'x'
  }), "\n");
};
exports.euiXScrollWithShadows = euiXScrollWithShadows;
var useEuiXScrollWithShadows = function useEuiXScrollWithShadows() {
  var euiTheme = (0, _theme.useEuiTheme)();
  return euiXScrollWithShadows(euiTheme);
};
exports.useEuiXScrollWithShadows = useEuiXScrollWithShadows;
var euiOverflowScroll = function euiOverflowScroll(euiTheme) {
  var _ref9 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    direction = _ref9.direction,
    _ref9$mask = _ref9.mask,
    mask = _ref9$mask === void 0 ? false : _ref9$mask;
  switch (direction) {
    case 'y':
      return mask ? euiYScrollWithShadows(euiTheme) : euiYScroll(euiTheme);
    case 'x':
      return mask ? euiXScrollWithShadows(euiTheme) : euiXScroll(euiTheme);
    default:
      console.warn('Please provide a valid direction option to useEuiOverflowScroll');
      return '';
  }
};
exports.euiOverflowScroll = euiOverflowScroll;
var useEuiOverflowScroll = function useEuiOverflowScroll(direction) {
  var mask = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var euiTheme = (0, _theme.useEuiTheme)();
  return euiOverflowScroll(euiTheme, {
    direction: direction,
    mask: mask
  });
};

/**
 * For quickly applying a full-height element whether using flex or not
 */
exports.useEuiOverflowScroll = useEuiOverflowScroll;
var euiFullHeight = function euiFullHeight() {
  return "\n  ".concat((0, _functions.logicalCSS)('height', '100%'), "\n  flex: 1 1 auto;\n  overflow: hidden;\n");
};

/**
 * A constant storing the support for the `:has()` selector through a
 * media query that will only apply the content it is supported.
 */
exports.euiFullHeight = euiFullHeight;
var euiSupportsHas = '@supports(selector(:has(p)))';
exports.euiSupportsHas = euiSupportsHas;