"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiBackgroundColorCSS = exports.useEuiBackgroundColor = exports.euiBackgroundColor = exports.BACKGROUND_COLORS = void 0;
var _react = require("@emotion/react");
var _services = require("../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var BACKGROUND_COLORS = ['transparent', 'plain', 'subdued', 'accent', 'primary', 'success', 'warning', 'danger'];
exports.BACKGROUND_COLORS = BACKGROUND_COLORS;
var euiBackgroundColor = function euiBackgroundColor(_ref, color) {
  var euiTheme = _ref.euiTheme,
    colorMode = _ref.colorMode;
  var _ref2 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
    method = _ref2.method;
  if (color === 'transparent') return 'transparent';
  if (method === 'transparent') {
    if (color === 'plain') {
      return (0, _services.transparentize)(euiTheme.colors.ghost, 0.2);
    } else if (color === 'subdued') {
      return colorMode === 'DARK' ? (0, _services.transparentize)(euiTheme.colors.lightShade, 0.4) : (0, _services.transparentize)(euiTheme.colors.lightShade, 0.2);
    } else {
      return (0, _services.transparentize)(euiTheme.colors[color], 0.1);
    }
  } else {
    var tintOrShade = function tintOrShade(color) {
      return colorMode === 'DARK' ? (0, _services.shade)(color, 0.8) : (0, _services.tint)(color, 0.9);
    };
    switch (color) {
      case 'plain':
        return euiTheme.colors.emptyShade;
      case 'subdued':
        return euiTheme.colors.body;
      default:
        return tintOrShade(euiTheme.colors[color]);
    }
  }
};
exports.euiBackgroundColor = euiBackgroundColor;
var useEuiBackgroundColor = function useEuiBackgroundColor(color) {
  var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    method = _ref3.method;
  var euiTheme = (0, _services.useEuiTheme)();
  return euiBackgroundColor(euiTheme, color, {
    method: method
  });
};
exports.useEuiBackgroundColor = useEuiBackgroundColor;
var useEuiBackgroundColorCSS = function useEuiBackgroundColorCSS() {
  return {
    transparent: /*#__PURE__*/(0, _react.css)("background-color:", useEuiBackgroundColor('transparent'), ";;label:transparent;"),
    plain: /*#__PURE__*/(0, _react.css)("background-color:", useEuiBackgroundColor('plain'), ";;label:plain;"),
    subdued: /*#__PURE__*/(0, _react.css)("background-color:", useEuiBackgroundColor('subdued'), ";;label:subdued;"),
    accent: /*#__PURE__*/(0, _react.css)("background-color:", useEuiBackgroundColor('accent'), ";;label:accent;"),
    primary: /*#__PURE__*/(0, _react.css)("background-color:", useEuiBackgroundColor('primary'), ";;label:primary;"),
    success: /*#__PURE__*/(0, _react.css)("background-color:", useEuiBackgroundColor('success'), ";;label:success;"),
    warning: /*#__PURE__*/(0, _react.css)("background-color:", useEuiBackgroundColor('warning'), ";;label:warning;"),
    danger: /*#__PURE__*/(0, _react.css)("background-color:", useEuiBackgroundColor('danger'), ";;label:danger;")
  };
};
exports.useEuiBackgroundColorCSS = useEuiBackgroundColorCSS;