"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiToolTipPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _tool_tip = require("./tool_tip.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "title", "className", "positionToolTip", "popoverRef", "calculatedPosition"];
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiToolTipPopover = function EuiToolTipPopover(_ref) {
  var children = _ref.children,
    title = _ref.title,
    className = _ref.className,
    positionToolTip = _ref.positionToolTip,
    popoverRef = _ref.popoverRef,
    calculatedPosition = _ref.calculatedPosition,
    rest = _objectWithoutProperties(_ref, _excluded);
  var popover = (0, _react.useRef)();
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _tool_tip.euiToolTipStyles)(euiTheme);
  var cssStyles = [styles.euiToolTip, calculatedPosition && styles[calculatedPosition]];
  var updateDimensions = (0, _react.useCallback)(function () {
    requestAnimationFrame(function () {
      // Because of this delay, sometimes `positionToolTip` becomes unavailable.
      if (popover.current) {
        positionToolTip();
      }
    });
  }, [positionToolTip]);
  var setPopoverRef = function setPopoverRef(ref) {
    if (popoverRef) {
      popoverRef(ref);
    }
  };
  (0, _react.useEffect)(function () {
    document.body.classList.add('euiBody-hasPortalContent');
    window.addEventListener('resize', updateDimensions);
    return function () {
      document.body.classList.remove('euiBody-hasPortalContent');
      window.removeEventListener('resize', updateDimensions);
    };
  }, [updateDimensions]);
  var classes = (0, _classnames.default)('euiToolTipPopover', className);
  return (0, _react2.jsx)("div", _extends({
    css: cssStyles,
    className: classes,
    ref: setPopoverRef,
    "data-position": calculatedPosition
  }, rest), title && (0, _react2.jsx)("div", {
    css: styles.euiToolTip__title,
    className: "euiToolTip__title"
  }, title), children);
};
exports.EuiToolTipPopover = EuiToolTipPopover;
EuiToolTipPopover.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  positionToolTip: _propTypes.default.func.isRequired,
  children: _propTypes.default.node,
  title: _propTypes.default.node,
  popoverRef: _propTypes.default.func,
  calculatedPosition: _propTypes.default.oneOf(["top", "right", "bottom", "left"])
};