"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.POSITIONS = exports.EuiToolTip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _common = require("../common");
var _services = require("../../services");
var _react2 = require("../../services/react");
var _resize_observer = require("../observer/resize_observer");
var _portal = require("../portal");
var _tool_tip_popover = require("./tool_tip_popover");
var _tool_tip_anchor = require("./tool_tip_anchor");
var _tool_tip_arrow = require("./tool_tip_arrow");
var _tool_tip_manager = require("./tool_tip_manager");
var _react3 = require("@emotion/react");
var _excluded = ["children", "className", "anchorClassName", "anchorProps", "content", "title", "delay", "display", "repositionOnScroll"];
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var positionsToClassNameMap = {
  top: 'euiToolTip--top',
  right: 'euiToolTip--right',
  bottom: 'euiToolTip--bottom',
  left: 'euiToolTip--left'
};
var POSITIONS = (0, _common.keysOf)(positionsToClassNameMap);
exports.POSITIONS = POSITIONS;
var delayToMsMap = {
  regular: 250,
  long: 250 * 5
};
var displayToClassNameMap = {
  inlineBlock: undefined,
  block: 'euiToolTipAnchor--displayBlock'
};
var DEFAULT_TOOLTIP_STYLES = {
  // position the tooltip content near the top-left
  // corner of the window so it can't create scrollbars
  // 50,50 because who knows what negative margins, padding, etc
  top: 50,
  left: 50,
  // just in case, avoid any potential flicker by hiding
  // the tooltip before it is positioned
  opacity: 0,
  // prevent accidental mouse interaction while positioning
  visibility: 'hidden'
};
var EuiToolTip = /*#__PURE__*/function (_Component) {
  _inherits(EuiToolTip, _Component);
  var _super = _createSuper(EuiToolTip);
  function EuiToolTip() {
    var _this;
    _classCallCheck(this, EuiToolTip);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "_isMounted", false);
    _defineProperty(_assertThisInitialized(_this), "anchor", null);
    _defineProperty(_assertThisInitialized(_this), "popover", null);
    _defineProperty(_assertThisInitialized(_this), "timeoutId", void 0);
    _defineProperty(_assertThisInitialized(_this), "state", {
      visible: false,
      hasFocus: false,
      calculatedPosition: _this.props.position,
      toolTipStyles: DEFAULT_TOOLTIP_STYLES,
      arrowStyles: undefined,
      id: _this.props.id || (0, _services.htmlIdGenerator)()()
    });
    _defineProperty(_assertThisInitialized(_this), "clearAnimationTimeout", function () {
      if (_this.timeoutId) {
        _this.timeoutId = clearTimeout(_this.timeoutId);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "testAnchor", function () {
      // when the tooltip is visible, this checks if the anchor is still part of document
      // this fixes when the react root is removed from the dom without unmounting
      // https://github.com/elastic/eui/issues/1105
      if (document.body.contains(_this.anchor) === false) {
        // the anchor is no longer part of `document`
        _this.hideToolTip();
      } else {
        if (_this.state.visible) {
          // if still visible, keep checking
          requestAnimationFrame(_this.testAnchor);
        }
      }
    });
    _defineProperty(_assertThisInitialized(_this), "setAnchorRef", function (ref) {
      return _this.anchor = ref;
    });
    _defineProperty(_assertThisInitialized(_this), "setPopoverRef", function (ref) {
      return _this.popover = ref;
    });
    _defineProperty(_assertThisInitialized(_this), "showToolTip", function () {
      if (!_this.timeoutId) {
        _this.timeoutId = setTimeout(function () {
          (0, _react2.enqueueStateChange)(function () {
            _this.setState({
              visible: true
            });
            _tool_tip_manager.toolTipManager.registerTooltip(_this.hideToolTip);
          });
        }, delayToMsMap[_this.props.delay]);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "positionToolTip", function () {
      var requestedPosition = _this.props.position;
      if (!_this.anchor || !_this.popover) {
        return;
      }
      var _findPopoverPosition = (0, _services.findPopoverPosition)({
          anchor: _this.anchor,
          popover: _this.popover,
          position: requestedPosition,
          offset: 16,
          // offset popover 16px from the anchor
          arrowConfig: {
            arrowWidth: 12,
            arrowBuffer: 4
          }
        }),
        position = _findPopoverPosition.position,
        left = _findPopoverPosition.left,
        top = _findPopoverPosition.top,
        arrow = _findPopoverPosition.arrow;

      // If encroaching the right edge of the window:
      // When `props.content` changes and is longer than `prevProps.content`, the tooltip width remains and
      // the resizeObserver callback will fire twice (once for vertical resize caused by text line wrapping,
      // once for a subsequent position correction) and cause a flash rerender and reposition.
      // To prevent this, we can orient from the right so that text line wrapping does not occur, negating
      // the second resizeObserver callback call.
      var windowWidth = document.documentElement.clientWidth || window.innerWidth;
      var useRightValue = windowWidth / 2 < left;
      var toolTipStyles = {
        top: top,
        left: useRightValue ? 'auto' : left,
        right: useRightValue ? windowWidth - left - _this.popover.offsetWidth : 'auto'
      };
      _this.setState({
        visible: true,
        calculatedPosition: position,
        toolTipStyles: toolTipStyles,
        arrowStyles: arrow
      });
    });
    _defineProperty(_assertThisInitialized(_this), "hideToolTip", function () {
      _this.clearAnimationTimeout();
      (0, _react2.enqueueStateChange)(function () {
        if (_this._isMounted) {
          _this.setState({
            visible: false,
            toolTipStyles: DEFAULT_TOOLTIP_STYLES,
            arrowStyles: undefined
          });
          _tool_tip_manager.toolTipManager.deregisterToolTip(_this.hideToolTip);
        }
      });
    });
    _defineProperty(_assertThisInitialized(_this), "onFocus", function () {
      _this.setState({
        hasFocus: true
      });
      _this.showToolTip();
    });
    _defineProperty(_assertThisInitialized(_this), "onBlur", function () {
      _this.setState({
        hasFocus: false
      });
      _this.hideToolTip();
    });
    _defineProperty(_assertThisInitialized(_this), "onMouseOut", function (event) {
      // Prevent mousing over children from hiding the tooltip by testing for whether the mouse has
      // left the anchor for a non-child.
      if (_this.anchor === event.relatedTarget || _this.anchor != null && !_this.anchor.contains(event.relatedTarget)) {
        if (!_this.state.hasFocus) {
          _this.hideToolTip();
        }
      }
      if (_this.props.onMouseOut) {
        _this.props.onMouseOut(event);
      }
    });
    return _this;
  }
  _createClass(EuiToolTip, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this._isMounted = true;
      if (this.props.repositionOnScroll) {
        window.addEventListener('scroll', this.positionToolTip, true);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.clearAnimationTimeout();
      this._isMounted = false;
      window.removeEventListener('scroll', this.positionToolTip, true);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      if (prevState.visible === false && this.state.visible === true) {
        requestAnimationFrame(this.testAnchor);
      }

      // update scroll listener
      if (prevProps.repositionOnScroll !== this.props.repositionOnScroll) {
        if (this.props.repositionOnScroll) {
          window.addEventListener('scroll', this.positionToolTip, true);
        } else {
          window.removeEventListener('scroll', this.positionToolTip, true);
        }
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        children = _this$props.children,
        className = _this$props.className,
        anchorClassName = _this$props.anchorClassName,
        anchorProps = _this$props.anchorProps,
        content = _this$props.content,
        title = _this$props.title,
        delay = _this$props.delay,
        display = _this$props.display,
        repositionOnScroll = _this$props.repositionOnScroll,
        rest = _objectWithoutProperties(_this$props, _excluded);
      var _this$state = this.state,
        arrowStyles = _this$state.arrowStyles,
        id = _this$state.id,
        toolTipStyles = _this$state.toolTipStyles,
        visible = _this$state.visible,
        calculatedPosition = _this$state.calculatedPosition;
      var classes = (0, _classnames.default)('euiToolTip', className);
      var anchorClasses = (0, _classnames.default)(anchorClassName, anchorProps === null || anchorProps === void 0 ? void 0 : anchorProps.className);
      return (0, _react3.jsx)(_react.default.Fragment, null, (0, _react3.jsx)(_tool_tip_anchor.EuiToolTipAnchor, _extends({}, anchorProps, {
        ref: this.setAnchorRef,
        onBlur: this.onBlur,
        onFocus: this.onFocus,
        onMouseOver: this.showToolTip,
        onMouseOut: this.onMouseOut,
        id: this.state.id,
        className: anchorClasses,
        display: display,
        isVisible: visible
      }), children), visible && (content || title) && (0, _react3.jsx)(_portal.EuiPortal, null, (0, _react3.jsx)(_tool_tip_popover.EuiToolTipPopover, _extends({
        className: classes,
        style: toolTipStyles,
        positionToolTip: this.positionToolTip,
        popoverRef: this.setPopoverRef,
        title: title,
        id: id,
        role: "tooltip",
        calculatedPosition: calculatedPosition
      }, rest), (0, _react3.jsx)(_tool_tip_arrow.EuiToolTipArrow, {
        style: arrowStyles,
        className: "euiToolTip__arrow",
        position: calculatedPosition
      }), (0, _react3.jsx)(_resize_observer.EuiResizeObserver, {
        onResize: this.positionToolTip
      }, function (resizeRef) {
        return (0, _react3.jsx)("div", {
          ref: resizeRef
        }, content);
      }))));
    }
  }]);
  return EuiToolTip;
}(_react.Component);
exports.EuiToolTip = EuiToolTip;
_defineProperty(EuiToolTip, "defaultProps", {
  position: 'top',
  delay: 'regular',
  display: 'inlineBlock'
});
EuiToolTip.propTypes = {
  /**
     * Passes onto the span wrapping the trigger.
     */
  anchorClassName: _propTypes.default.string,
  /**
     * Passes onto the span wrapping the trigger.
     */
  anchorProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),
  /**
     * The in-view trigger for your tooltip.
     */
  children: _propTypes.default.element.isRequired,
  /**
     * Passes onto the tooltip itself, not the trigger.
     */
  className: _propTypes.default.string,
  /**
     * The main content of your tooltip.
     */
  content: _propTypes.default.node,
  /**
     * Common display alternatives for the anchor wrapper
     */
  display: _propTypes.default.oneOf(["inlineBlock", "block"]),
  /**
     * Delay before showing tooltip. Good for repeatable items.
     */
  delay: _propTypes.default.oneOf(["regular", "long"]).isRequired,
  /**
     * An optional title for your tooltip.
     */
  title: _propTypes.default.node,
  /**
     * Unless you provide one, this will be randomly generated.
     */
  id: _propTypes.default.string,
  /**
     * Suggested position. If there is not enough room for it this will be changed.
     */
  position: _propTypes.default.oneOf(["top", "right", "bottom", "left"]).isRequired,
  /**
     * When `true`, the tooltip's position is re-calculated when the user
     * scrolls. This supports having fixed-position tooltip anchors.
     *
     * When nesting an `EuiTooltip` in a scrollable container, `repositionOnScroll` should be `true`
     */
  repositionOnScroll: _propTypes.default.bool,
  /**
     * If supplied, called when mouse movement causes the tool tip to be
     * hidden.
     */
  onMouseOut: _propTypes.default.func
};