"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTableRowCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _utils = require("./utils");
var _react2 = require("@emotion/react");
var _excluded = ["align", "children", "className", "truncateText", "setScopeRow", "showOnHover", "textOnly", "hasActions", "isExpander", "style", "width", "valign", "mobileOptions"];
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiTableRowCell = function EuiTableRowCell(_ref) {
  var _mobileOptions$showOn, _mobileOptions$trunca;
  var _ref$align = _ref.align,
    align = _ref$align === void 0 ? _services.LEFT_ALIGNMENT : _ref$align,
    children = _ref.children,
    className = _ref.className,
    truncateText = _ref.truncateText,
    setScopeRow = _ref.setScopeRow,
    showOnHover = _ref.showOnHover,
    _ref$textOnly = _ref.textOnly,
    textOnly = _ref$textOnly === void 0 ? true : _ref$textOnly,
    hasActions = _ref.hasActions,
    isExpander = _ref.isExpander,
    style = _ref.style,
    width = _ref.width,
    _ref$valign = _ref.valign,
    valign = _ref$valign === void 0 ? 'middle' : _ref$valign,
    _ref$mobileOptions = _ref.mobileOptions,
    mobileOptions = _ref$mobileOptions === void 0 ? {
      show: true
    } : _ref$mobileOptions,
    rest = _objectWithoutProperties(_ref, _excluded);
  var cellClasses = (0, _classnames.default)('euiTableRowCell', _defineProperty({
    'euiTableRowCell--hasActions': hasActions,
    'euiTableRowCell--isExpander': isExpander,
    'euiTableRowCell--hideForDesktop': mobileOptions.only,
    'euiTableRowCell--enlargeForMobile': mobileOptions.enlarge
  }, "euiTableRowCell--".concat(valign), valign));
  var contentClasses = (0, _classnames.default)('euiTableCellContent', className, {
    'euiTableCellContent--alignRight': align === _services.RIGHT_ALIGNMENT,
    'euiTableCellContent--alignCenter': align === _services.CENTER_ALIGNMENT,
    'euiTableCellContent--showOnHover': showOnHover,
    'euiTableCellContent--truncateText': truncateText,
    // We're doing this rigamarole instead of creating `euiTableCellContent--textOnly` for BWC
    // purposes for the time-being.
    'euiTableCellContent--overflowingContent': textOnly !== true
  });
  var mobileContentClasses = (0, _classnames.default)('euiTableCellContent', className, {
    'euiTableCellContent--alignRight': mobileOptions.align === _services.RIGHT_ALIGNMENT || align === _services.RIGHT_ALIGNMENT,
    'euiTableCellContent--alignCenter': mobileOptions.align === _services.CENTER_ALIGNMENT || align === _services.CENTER_ALIGNMENT,
    'euiTableCellContent--showOnHover': (_mobileOptions$showOn = mobileOptions.showOnHover) !== null && _mobileOptions$showOn !== void 0 ? _mobileOptions$showOn : showOnHover,
    'euiTableCellContent--truncateText': (_mobileOptions$trunca = mobileOptions.truncateText) !== null && _mobileOptions$trunca !== void 0 ? _mobileOptions$trunca : truncateText,
    // We're doing this rigamarole instead of creating `euiTableCellContent--textOnly` for BWC
    // purposes for the time-being.
    'euiTableCellContent--overflowingContent': mobileOptions.textOnly !== true || textOnly !== true
  });
  var childClasses = (0, _classnames.default)({
    euiTableCellContent__text: textOnly === true,
    euiTableCellContent__hoverItem: showOnHover
  });
  var widthValue = (0, _services.useIsWithinBreakpoints)(['xs', 's']) && mobileOptions.width ? mobileOptions.width : width;
  var styleObj = (0, _utils.resolveWidthAsStyle)(style, widthValue);
  function modifyChildren(children) {
    var modifiedChildren = children;
    if (textOnly === true) {
      modifiedChildren = (0, _react2.jsx)("span", {
        className: childClasses
      }, children);
    } else if ( /*#__PURE__*/_react.default.isValidElement(children)) {
      modifiedChildren = _react.default.Children.map(children, function (child) {
        return /*#__PURE__*/_react.default.cloneElement(child, {
          className: (0, _classnames.default)(child.props.className, childClasses)
        });
      });
    }
    return modifiedChildren;
  }
  var childrenNode = modifyChildren(children);
  var hideForMobileClasses = 'euiTableRowCell--hideForMobile';
  var showForMobileClasses = 'euiTableRowCell--hideForDesktop';
  var Element = setScopeRow ? 'th' : 'td';
  var sharedProps = _objectSpread({
    scope: setScopeRow ? 'row' : undefined,
    style: styleObj
  }, rest);
  if (mobileOptions.show === false) {
    return (0, _react2.jsx)(Element, _extends({
      className: "".concat(cellClasses, " ").concat(hideForMobileClasses)
    }, sharedProps), (0, _react2.jsx)("div", {
      className: contentClasses
    }, childrenNode));
  } else {
    return (0, _react2.jsx)(Element, _extends({
      className: cellClasses
    }, sharedProps), mobileOptions.header && (0, _react2.jsx)("div", {
      className: "euiTableRowCell__mobileHeader ".concat(showForMobileClasses)
    }, mobileOptions.header), mobileOptions.render ? (0, _react2.jsx)(_react.Fragment, null, (0, _react2.jsx)("div", {
      className: "".concat(mobileContentClasses, " ").concat(showForMobileClasses)
    }, modifyChildren(mobileOptions.render)), (0, _react2.jsx)("div", {
      className: "".concat(contentClasses, " ").concat(hideForMobileClasses)
    }, childrenNode)) : (0, _react2.jsx)("div", {
      className: contentClasses
    }, childrenNode));
  }
};
exports.EuiTableRowCell = EuiTableRowCell;
EuiTableRowCell.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * Vertical alignment of the content in the cell
     */
  valign: _propTypes.default.any,
  /**
     * Indicates whether the cell should be marked as the heading for its row
     */
  setScopeRow: _propTypes.default.bool,
  /**
     * Indicates if the column is dedicated to icon-only actions (currently
     * affects mobile only)
     */
  hasActions: _propTypes.default.bool,
  /**
     * Indicates if the column is dedicated as the expandable row toggle
     */
  isExpander: _propTypes.default.bool,
  /**
     * Mobile options for displaying differently at small screens;
     * See #EuiTableRowCellMobileOptionsShape
     */
  mobileOptions: _propTypes.default.shape({
    /**
       * If false, will not render the cell at all for mobile
       */
    show: _propTypes.default.bool,
    /**
       * Only show for mobile? If true, will not render the column at all for desktop
       */
    only: _propTypes.default.bool,
    /**
       * Custom render/children if different from desktop
       */
    render: _propTypes.default.node,
    /**
       * The column's header for use in mobile view (automatically passed down
       * when using `EuiBasicTable`).
       * Or pass `false` to not show a header at all.
       */
    header: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.bool.isRequired]),
    /**
       * Increase text size compared to rest of cells
       */
    enlarge: _propTypes.default.bool,
    /**
       * Applies the value to the width of the cell in mobile view (typically 50%)
       */
    width: _propTypes.default.any,
    /**
       * Horizontal alignment of the text in the cell
       */
    align: _propTypes.default.any,
    /**
       * _Should only be used for action cells_
       */
    showOnHover: _propTypes.default.bool,
    /**
       * Creates a text wrapper around cell content that helps word break or truncate
       * long text correctly.
       */
    textOnly: _propTypes.default.bool,
    /**
       * Don't allow line breaks within cells
       */
    truncateText: _propTypes.default.bool
  }),
  /**
     * Horizontal alignment of the text in the cell
     */
  align: _propTypes.default.any,
  /**
     * _Should only be used for action cells_
     */
  showOnHover: _propTypes.default.bool,
  /**
     * Creates a text wrapper around cell content that helps word break or truncate
     * long text correctly.
     */
  textOnly: _propTypes.default.bool,
  /**
     * Don't allow line breaks within cells
     */
  truncateText: _propTypes.default.bool,
  width: _propTypes.default.any
};