"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STATUS = exports.EuiStepNumber = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _accessibility = require("../accessibility");
var _icon = require("../icon");
var _step_strings = require("./step_strings");
var _loading = require("../loading");
var _services = require("../../services");
var _step_number = require("./step_number.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "status", "number", "titleSize"];
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var STATUS = ['incomplete', 'disabled', 'loading', 'warning', 'danger', 'complete', 'current'];
exports.STATUS = STATUS;
var EuiStepNumber = function EuiStepNumber(_ref) {
  var className = _ref.className,
    status = _ref.status,
    number = _ref.number,
    _ref$titleSize = _ref.titleSize,
    titleSize = _ref$titleSize === void 0 ? 's' : _ref$titleSize,
    rest = _objectWithoutProperties(_ref, _excluded);
  var ariaLabelsMap = {
    step: (0, _step_strings.useI18nStep)({
      number: number
    }),
    current: (0, _step_strings.useI18nCurrentStep)({
      number: number
    }),
    incomplete: (0, _step_strings.useI18nIncompleteStep)({
      number: number
    }),
    complete: (0, _step_strings.useI18nCompleteStep)({
      number: number
    }),
    disabled: (0, _step_strings.useI18nDisabledStep)({
      number: number
    }),
    warning: (0, _step_strings.useI18nWarningStep)({
      number: number
    }),
    danger: (0, _step_strings.useI18nErrorsStep)({
      number: number
    }),
    loading: (0, _step_strings.useI18nLoadingStep)({
      number: number
    })
  };
  var classes = (0, _classnames.default)('euiStepNumber', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _step_number.euiStepNumberStyles)(euiTheme);
  var cssStyles = [styles.euiStepNumber, styles[titleSize], status && styles[status]];
  var contentStyles = (0, _step_number.euiStepNumberContentStyles)(euiTheme);
  var content;
  var screenReaderText;
  switch (status) {
    // Loading spinner
    case 'loading':
      screenReaderText = ariaLabelsMap.loading;
      content = (0, _react2.jsx)(_loading.EuiLoadingSpinner, {
        className: "euiStepNumber__loader",
        size: titleSize === 'xs' ? 'l' : 'xl'
      });
      break;
    // Statuses with icons
    case 'danger':
    case 'warning':
    case 'complete':
      var cssIconStyles = [contentStyles.euiStepNumber__icon, contentStyles[status]];
      var iconTypeMap = {
        danger: 'cross',
        warning: 'warning',
        complete: 'check'
      };
      content = (0, _react2.jsx)(_icon.EuiIcon, {
        type: iconTypeMap[status],
        "aria-label": ariaLabelsMap[status],
        size: titleSize === 'xs' ? 's' : 'm',
        className: "euiStepNumber__icon",
        css: cssIconStyles
      });
      break;
    // Statuses with numbers
    case 'incomplete':
    case 'current':
    case 'disabled':
    default:
      var cssNumberStyles = [contentStyles.euiStepNumber__number, status && contentStyles[status]];
      screenReaderText = ariaLabelsMap[status || 'step'];
      content = (0, _react2.jsx)("span", {
        "aria-hidden": "true",
        className: "euiStepNumber__number",
        css: cssNumberStyles
      }, number);
      break;
  }
  return (0, _react2.jsx)("span", _extends({
    className: classes,
    css: cssStyles
  }, rest), screenReaderText && (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, screenReaderText)), content);
};
exports.EuiStepNumber = EuiStepNumber;
EuiStepNumber.propTypes = {
  /**
     * May replace the number provided in props.number with alternate styling
     */
  status: _propTypes.default.any,
  number: _propTypes.default.number,
  /**
     * Title sizing equivalent to EuiTitle, but only `m`, `s` and `xs`. Defaults to `s`
     */
  titleSize: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};