"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSkeletonLoading = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _screen_reader_live = require("../accessibility/screen_reader_live");
var _i18n = require("../i18n");
var _react2 = require("@emotion/react");
var _excluded = ["isLoading", "contentAriaLabel", "loadingContent", "loadedContent"];
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiSkeletonLoading = function EuiSkeletonLoading(_ref) {
  var _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? true : _ref$isLoading,
    contentAriaLabel = _ref.contentAriaLabel,
    loadingContent = _ref.loadingContent,
    loadedContent = _ref.loadedContent,
    rest = _objectWithoutProperties(_ref, _excluded);
  var loadingAriaLabel = (0, _i18n.useEuiI18n)('euiSkeletonLoading.loadingAriaText', 'Loading {contentAriaLabel}', {
    contentAriaLabel: contentAriaLabel
  });
  var loadedAriaLive = (0, _i18n.useEuiI18n)('euiSkeletonLoading.loadedAriaText', 'Loaded {contentAriaLabel}', {
    contentAriaLabel: contentAriaLabel
  });
  var loadingProps = {
    'aria-label': loadingAriaLabel,
    role: 'progressbar'
  };
  return (0, _react2.jsx)("div", _extends({
    "aria-busy": isLoading,
    "data-test-subj": "euiSkeletonLoadingAriaWrapper"
  }, rest), isLoading ? /*#__PURE__*/_react.default.cloneElement(loadingContent, loadingProps) : (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_screen_reader_live.EuiScreenReaderLive, null, loadedAriaLive), loadedContent));
};
exports.EuiSkeletonLoading = EuiSkeletonLoading;
EuiSkeletonLoading.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Content to display when loading
       */
  loadingContent: _propTypes.default.element.isRequired,
  /**
       * Content to display when loaded
       */
  loadedContent: _propTypes.default.any.isRequired
};