"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var _react = _interopRequireWildcard(require("react"));
var _button = require("../button");
var _popover = require("../popover");
var _selectable = require("./selectable");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
var options = [{
  label: 'Titan',
  'data-test-subj': 'titanOption'
}, {
  label: 'Enceladus'
}, {
  label: "Pandora is one of Saturn's moons, named for a Titaness of Greek mythology"
}];
var EuiSelectableListboxOnly = function EuiSelectableListboxOnly(args) {
  return (0, _react2.jsx)(_selectable.EuiSelectable, _extends({
    options: options
  }, args), function (list) {
    return (0, _react2.jsx)(_react.default.Fragment, null, list);
  });
};
var EuiSelectableWithSearchInput = function EuiSelectableWithSearchInput(args) {
  return (0, _react2.jsx)(_selectable.EuiSelectable, _extends({
    searchable: true,
    options: options
  }, args), function (list, search) {
    return (0, _react2.jsx)(_react.default.Fragment, null, search, list);
  });
};
describe('EuiSelectable', function () {
  describe('with a `searchable` configuration', function () {
    it('has no accessibility errors', function () {
      var onChange = cy.stub();
      cy.realMount((0, _react2.jsx)(EuiSelectableWithSearchInput, {
        onChange: onChange
      }));
      cy.checkAxe();
    });
  });
  describe('without a `searchable` configuration', function () {
    it('has no accessibility errors', function () {
      var onChange = cy.stub();
      cy.realMount((0, _react2.jsx)(EuiSelectableListboxOnly, {
        "aria-label": "No search box",
        onChange: onChange
      }));
      cy.checkAxe();
    });
  });
  describe('nested in `EuiPopover` component', function () {
    var EuiSelectableNested = function EuiSelectableNested() {
      var _useState = (0, _react.useState)(false),
        _useState2 = _slicedToArray(_useState, 2),
        isPopoverOpen = _useState2[0],
        setIsPopoverOpen = _useState2[1];
      var onChange = function onChange() {};
      var onClosePopover = function onClosePopover() {};
      var onButtonClick = function onButtonClick() {
        setIsPopoverOpen(!isPopoverOpen);
      };
      var button = (0, _react2.jsx)(_button.EuiButton, {
        iconType: "arrowDown",
        iconSide: "right",
        onClick: onButtonClick
      }, "Show popover");
      return (0, _react2.jsx)(_popover.EuiPopover, {
        id: "data-cy-popover-1",
        panelPaddingSize: "s",
        button: button,
        isOpen: isPopoverOpen,
        closePopover: onClosePopover
      }, (0, _react2.jsx)(EuiSelectableWithSearchInput, {
        "aria-label": "With popover",
        options: options,
        onChange: onChange
      }, function (list) {
        return (0, _react2.jsx)(_react.default.Fragment, null, list);
      }));
    };
    it('has no accessibility errors', function () {
      cy.realMount((0, _react2.jsx)(EuiSelectableNested, null));
      cy.get('button').realClick();
      cy.get('li[role=option]').first(); // Make sure the EuiSelectable is rendered before a11y check
      cy.checkAxe();
    });
  });
});