"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiProgressValueTextStyles = exports.euiProgressStyles = exports.euiProgressLabelStyles = exports.euiProgressDataStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _services = require("../../services");
var _text = require("../text/text.styles");
var _templateObject;
function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/**
 * DRY utilities for native/determinate progress components vs non-native indeterminate
 */
var crossBrowserProgressValue = function crossBrowserProgressValue(cssProperties) {
  return "\n  &::-webkit-progress-value {\n    ".concat(cssProperties, "\n  }\n  &::-moz-progress-bar {\n    ").concat(cssProperties, "\n  }\n");
};
var indeterminateProgressValue = function indeterminateProgressValue(cssProperties) {
  return "\n  &:before {\n    ".concat(cssProperties, "\n  }\n");
};

/**
 * Color utilities
 */
var visColors = (0, _services.euiPaletteColorBlind)();
var nativeVsIndeterminateColor = function nativeVsIndeterminateColor(color, isNative) {
  var selectors = isNative ? crossBrowserProgressValue : indeterminateProgressValue;
  return selectors("background-color: ".concat(color, ";"));
};

/**
 * DRY utils for non-static positions
 */
var nonStaticPositioning = function nonStaticPositioning(isNative) {
  return "\n  ".concat((0, _global_styling.logicalCSS)('top', 0), "\n  ").concat((0, _global_styling.logicalCSS)('left', 0), "\n  ").concat((0, _global_styling.logicalCSS)('right', 0), "\n  background-color: transparent;\n  ").concat(isNative ? "\n      &::-webkit-progress-bar {\n        background-color: transparent;\n      }" : '', "\n");
};

/**
 * Animations
 */
var euiIndeterminateAnimation = (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  0% {\n    transform: scaleX(1) translateX(-100%);\n  }\n  100% {\n    transform: scaleX(1) translateX(100%);\n  }\n"])));

/**
 * Emotion styles
 */
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "187h6sp-static",
  styles: "position:relative;label:static;"
} : {
  name: "187h6sp-static",
  styles: "position:relative;label:static;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiProgressStyles = function euiProgressStyles(_ref3, isNative) {
  var euiTheme = _ref3.euiTheme;
  return {
    euiProgress: /*#__PURE__*/(0, _react.css)("overflow:hidden;background-color:", euiTheme.colors.lightShade, ";;label:euiProgress;"),
    // https://css-tricks.com/html5-progress-element/
    // Good resource if you need to work in here. There's some gotchas with
    // dealing with cross-browser progress bars.
    native: /*#__PURE__*/(0, _react.css)("display:block;", (0, _global_styling.logicalCSS)('width', '100%'), " appearance:none;border:none;border-radius:", euiTheme.size.s, ";&::-webkit-progress-bar{background-color:", euiTheme.colors.lightShade, ";}", crossBrowserProgressValue("transition: width ".concat(euiTheme.animation.normal, " linear;")), ";;label:native;"),
    // An indeterminate bar has an unreliable end time. Because of a Firefox animation issue,
    // we apply this style to a <div> instead of a <progress> element.
    // See https://css-tricks.com/html5-progress-element/ for more info.
    indeterminate: /*#__PURE__*/(0, _react.css)("&:before{position:absolute;content:'';", (0, _global_styling.logicalCSS)('width', '100%'), " ", (0, _global_styling.logicalCSS)('top', 0), " ", (0, _global_styling.logicalCSS)('bottom', 0), " ", (0, _global_styling.logicalCSS)('left', 0), " transform:scaleX(0) translateX(0%);animation:", euiIndeterminateAnimation, " 1s ", euiTheme.animation.resistance, " infinite;", _global_styling.euiCantAnimate, "{animation-duration:2s;animation-timing-function:linear;}};label:indeterminate;"),
    // Sizes
    xs: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', euiTheme.size.xxs), ";;label:xs;"),
    s: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', euiTheme.size.xs), ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', euiTheme.size.s), ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', euiTheme.size.m), ";;label:l;"),
    // Positioning
    fixed: /*#__PURE__*/(0, _react.css)("position:fixed;z-index:", Number(euiTheme.levels.header) + 1, ";", nonStaticPositioning(isNative), ";;label:fixed;"),
    absolute: /*#__PURE__*/(0, _react.css)("position:absolute;", nonStaticPositioning(isNative), ";;label:absolute;"),
    static: _ref2,
    // Colors
    primary: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.primary, isNative), ";;label:primary;"),
    success: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.success, isNative), ";;label:success;"),
    warning: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.warning, isNative), ";;label:warning;"),
    danger: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.danger, isNative), ";;label:danger;"),
    subdued: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.subduedText, isNative), ";;label:subdued;"),
    accent: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(euiTheme.colors.accent, isNative), ";;label:accent;"),
    vis0: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(visColors[0], isNative), ";;label:vis0;"),
    vis1: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(visColors[1], isNative), ";;label:vis1;"),
    vis2: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(visColors[2], isNative), ";;label:vis2;"),
    vis3: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(visColors[3], isNative), ";;label:vis3;"),
    vis4: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(visColors[4], isNative), ";;label:vis4;"),
    vis5: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(visColors[5], isNative), ";;label:vis5;"),
    vis6: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(visColors[6], isNative), ";;label:vis6;"),
    vis7: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(visColors[7], isNative), ";;label:vis7;"),
    vis8: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(visColors[8], isNative), ";;label:vis8;"),
    vis9: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor(visColors[9], isNative), ";;label:vis9;"),
    customColor: /*#__PURE__*/(0, _react.css)(nativeVsIndeterminateColor('currentColor', isNative), ";;label:customColor;")
  };
};

/**
 * Data styles
 */
exports.euiProgressStyles = euiProgressStyles;
var euiProgressDataStyles = function euiProgressDataStyles(euiThemeContext) {
  return {
    euiProgress__data: /*#__PURE__*/(0, _react.css)("display:flex;justify-content:space-between;gap:", euiThemeContext.euiTheme.size.xs, ";", (0, _text.euiText)(euiThemeContext.euiTheme), " ", (0, _global_styling.euiFontSize)(euiThemeContext, 'xs'), ";;label:euiProgress__data;"),
    // Sizes
    l: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 's'), ";;label:l;")
  };
};
exports.euiProgressDataStyles = euiProgressDataStyles;
var euiProgressLabelStyles = {
  euiProgress__label: /*#__PURE__*/(0, _react.css)("flex-grow:1;", (0, _global_styling.euiTextTruncate)(), ";;label:euiProgress__label;")
};
exports.euiProgressLabelStyles = euiProgressLabelStyles;
var _ref = process.env.NODE_ENV === "production" ? {
  name: "15ioh86-customColor",
  styles: "color:currentColor;label:customColor;"
} : {
  name: "15ioh86-customColor",
  styles: "color:currentColor;label:customColor;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiProgressValueTextStyles = function euiProgressValueTextStyles(_ref4) {
  var euiTheme = _ref4.euiTheme;
  return {
    euiProgress__valueText: /*#__PURE__*/(0, _react.css)("flex-grow:1;flex-shrink:0;font-feature-settings:'tnum' 1;", (0, _global_styling.logicalTextAlignCSS)('right'), " ", (0, _global_styling.euiTextTruncate)(), ";;label:euiProgress__valueText;"),
    // Colors
    primary: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.primaryText, ";;label:primary;"),
    success: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.successText, ";;label:success;"),
    warning: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.warningText, ";;label:warning;"),
    danger: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.dangerText, ";;label:danger;"),
    subdued: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.subduedText, ";;label:subdued;"),
    accent: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.accentText, ";;label:accent;"),
    vis0: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(visColors[0])(euiTheme), ";;label:vis0;"),
    vis1: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(visColors[1])(euiTheme), ";;label:vis1;"),
    vis2: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(visColors[2])(euiTheme), ";;label:vis2;"),
    vis3: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(visColors[3])(euiTheme), ";;label:vis3;"),
    vis4: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(visColors[4])(euiTheme), ";;label:vis4;"),
    vis5: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(visColors[5])(euiTheme), ";;label:vis5;"),
    vis6: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(visColors[6])(euiTheme), ";;label:vis6;"),
    vis7: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(visColors[7])(euiTheme), ";;label:vis7;"),
    vis8: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(visColors[8])(euiTheme), ";;label:vis8;"),
    vis9: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeHighContrastColor)(visColors[9])(euiTheme), ";;label:vis9;"),
    customColor: _ref
  };
};
exports.euiProgressValueTextStyles = euiProgressValueTextStyles;