"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiPaginationButtonStyles = exports.euiPaginationButtonArrowStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _mixins = require("../../themes/amsterdam/global_styling/mixins");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiPaginationButtonStyles = function euiPaginationButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var fontSizeS = (0, _global_styling.euiFontSize)(euiThemeContext, 's');
  var halfSizeM = (0, _global_styling.mathWithUnits)(euiTheme.size.m, function (x) {
    return x / 2;
  });
  var disabled = (0, _mixins.euiButtonEmptyColor)(euiThemeContext, 'disabled');

  // && to increase specificity. Can likely be removed once EuiButtonEmpty has been converted.

  return {
    // Base
    euiPaginationButton: /*#__PURE__*/(0, _react.css)("&&{", fontSizeS, ";padding:0;", (0, _global_styling.logicalTextAlignCSS)('center'), " border-radius:", euiTheme.border.radius.medium, ";outline-offset:-", euiTheme.focus.width, ";};label:euiPaginationButton;"),
    // States
    isActive: /*#__PURE__*/(0, _react.css)("&&{font-weight:", euiTheme.font.weight.bold, ";color:", euiTheme.colors.primary, ";.euiButtonEmpty__content{cursor:default;}&&,&&:hover{text-decoration:underline;}};label:isActive;"),
    isPlaceholder: /*#__PURE__*/(0, _react.css)("&&{align-items:baseline;color:", disabled.color, ";", fontSizeS, ";", (0, _global_styling.logicalCSS)('padding-top', halfSizeM), ";", (0, _global_styling.logicalCSS)('padding-bottom', 0), ";", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.s), ";", (0, _global_styling.logicalCSS)('height', euiTheme.size.l), ";};label:isPlaceholder;")
  };
};
exports.euiPaginationButtonStyles = euiPaginationButtonStyles;
var euiPaginationButtonArrowStyles = function euiPaginationButtonArrowStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiPaginationArrowButton: /*#__PURE__*/(0, _react.css)("outline-offset:-", euiTheme.focus.width, ";;label:euiPaginationArrowButton;")
  };
};
exports.euiPaginationButtonArrowStyles = euiPaginationButtonArrowStyles;