"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPageBody = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _restrict_width = require("../_restrict_width");
var _panel = require("../../panel");
var _global_styling = require("../../../global_styling");
var _page_body = require("./page_body.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "restrictWidth", "className", "component", "panelled", "panelProps", "paddingSize", "borderRadius"];
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiPageBody = function EuiPageBody(_ref) {
  var children = _ref.children,
    _ref$restrictWidth = _ref.restrictWidth,
    restrictWidth = _ref$restrictWidth === void 0 ? false : _ref$restrictWidth,
    className = _ref.className,
    _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'div' : _ref$component,
    panelled = _ref.panelled,
    panelProps = _ref.panelProps,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
    _ref$borderRadius = _ref.borderRadius,
    borderRadius = _ref$borderRadius === void 0 ? 'none' : _ref$borderRadius,
    rest = _objectWithoutProperties(_ref, _excluded);
  // Set max-width as a style prop
  var widthStyles = (0, _restrict_width.setStyleForRestrictedPageWidth)(restrictWidth, rest === null || rest === void 0 ? void 0 : rest.style);
  var styles = (0, _page_body.euiPageBodyStyles)();
  var padding = (0, _global_styling.useEuiPaddingCSS)()[paddingSize];
  var classes = (0, _classnames.default)('euiPageBody', className);
  var panelCSS = [styles.euiPageBody, restrictWidth && styles.restrictWidth];
  var componentCSS = [].concat(panelCSS, [padding]);
  return panelled ? (0, _react2.jsx)(_panel.EuiPanel, _extends({
    className: classes,
    css: panelCSS,
    borderRadius: borderRadius,
    paddingSize: paddingSize
  }, panelProps, rest), children) : (0, _react2.jsx)(Component, _extends({
    className: classes,
    css: componentCSS
  }, rest, {
    style: widthStyles
  }), children);
};
exports.EuiPageBody = EuiPageBody;