"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiOverlayMaskStyles = void 0;
var _css = require("@emotion/css");
var _global_styling = require("../../global_styling");
var _services = require("../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiOverlayMaskStyles = function euiOverlayMaskStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiOverlayMask: /*#__PURE__*/(0, _css.css)("position:fixed;", (0, _global_styling.logicalCSS)('top', 0), " ", (0, _global_styling.logicalCSS)('left', 0), " ", (0, _global_styling.logicalCSS)('right', 0), " ", (0, _global_styling.logicalCSS)('bottom', 0), " display:flex;align-items:center;justify-content:center;", (0, _global_styling.logicalCSS)('padding-bottom', '10vh'), ";animation:", _global_styling.euiAnimFadeIn, " ", euiTheme.animation.fast, " ease-in;background:", (0, _services.transparentize)(euiTheme.colors.ink, 0.5), ";;label:euiOverlayMask;"),
    aboveHeader: /*#__PURE__*/(0, _css.css)("z-index:", euiTheme.levels.mask, ";;label:aboveHeader;"),
    belowHeader: /*#__PURE__*/(0, _css.css)("z-index:", euiTheme.levels.maskBelowHeader, ";", (0, _global_styling.logicalCSS)('top', "".concat(euiTheme.base * 3, "px")), ";;label:belowHeader;")
  };
};
exports.euiOverlayMaskStyles = euiOverlayMaskStyles;