"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var _react = _interopRequireWildcard(require("react"));
var _context_menu = require("../context_menu");
var _notification_event = require("./notification_event");
var _panel = require("../panel");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
var NotificationEvent = function NotificationEvent() {
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isRead = _useState2[0],
    setIsRead = _useState2[1];
  var onRead = function onRead(id, isRead) {
    setIsRead(!isRead);
  };
  var onOpenContextMenu = function onOpenContextMenu(id) {
    return [(0, _react2.jsx)(_context_menu.EuiContextMenuItem, {
      key: "contextMenuItemA",
      onClick: function onClick() {
        return onRead(id, isRead);
      }
    }, isRead ? 'Mark as unread' : 'Mark as read'), (0, _react2.jsx)(_context_menu.EuiContextMenuItem, {
      key: "contextMenuItemB",
      onClick: function onClick() {}
    }, "View messages like this"), (0, _react2.jsx)(_context_menu.EuiContextMenuItem, {
      key: "contextMenuItemC",
      onClick: function onClick() {}
    }, "Don\u2019t notify me about this")];
  };
  return (0, _react2.jsx)(_panel.EuiPanel, {
    paddingSize: "none",
    hasShadow: true,
    style: {
      maxWidth: '540px'
    }
  }, (0, _react2.jsx)(_notification_event.EuiNotificationEvent, {
    id: "cy-eui-notification-1",
    type: "Report",
    iconType: "logoKibana",
    iconAriaLabel: "Kibana",
    time: "1 min ago",
    title: "[Error Monitoring Report] is generated",
    primaryAction: "Download",
    primaryActionProps: {
      iconType: 'download'
    },
    messages: ['The reported was generated at 17:12:16 GMT+4'],
    isRead: isRead,
    onRead: onRead,
    onOpenContextMenu: onOpenContextMenu,
    onClickPrimaryAction: function onClickPrimaryAction() {},
    onClickTitle: function onClickTitle() {}
  }));
};
describe('EuiNotificationEvent', function () {
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount((0, _react2.jsx)(NotificationEvent, null));
    cy.get('article.euiNotificationEvent').should('exist');
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when popover is open', function () {
      cy.get('button[data-test-subj="cy-eui-notification-1-notificationEventMetaButton"]').realClick();
      cy.get('div.euiPopover__panel').should('exist');
      cy.checkAxe();
    });
    it('has zero violations after the Mark as read button is clicked', function () {
      cy.get('button[data-test-subj="cy-eui-notification-1-notificationEventMetaButton"]').realClick();
      cy.get('div.euiPopover__panel').should('exist');
      cy.get('div.euiPopover__panel button').first().realClick();
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility', function () {
    it('has zero violations when the popover is opened by keyboard', function () {
      cy.repeatRealPress('Tab');
      cy.get('button[data-test-subj="cy-eui-notification-1-notificationEventMetaButton"]').should('have.focus');
      cy.realPress('Enter');
      cy.get('div.euiPopover__panel').should('exist');
      cy.checkAxe();
      cy.realPress('Escape');
      cy.get('div.euiPopover__panel').should('not.exist');
      cy.checkAxe();
    });
  });
});