"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiModalBody = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _modal_body = require("./modal_body.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "children"];
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiModalBody = function EuiModalBody(_ref) {
  var className = _ref.className,
    children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiModalBody', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _modal_body.euiModalBodyStyles)(euiTheme);
  var cssStyles = [styles.euiModalBody];
  var cssOverflowStyles = [styles.euiModalBody__overflow];
  return (0, _react2.jsx)("div", _extends({
    css: cssStyles,
    className: classes
  }, rest), (0, _react2.jsx)("div", {
    css: cssOverflowStyles,
    className: "euiModalBody__overflow"
  }, children));
};
exports.EuiModalBody = EuiModalBody;
EuiModalBody.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};