"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSpinnerBorderColorsCSS = exports.euiLoadingSpinnerStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _templateObject;
function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }
var _loadingSpinner = (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  from {\n    transform: rotate(0deg);\n  }\n\n  to {\n    transform: rotate(359deg);\n  }\n"])));
var spinnerSizes = {
  s: 'm',
  m: 'base',
  l: 'l',
  xl: 'xl',
  xxl: 'xxl'
};
var euiSpinnerBorderColorsCSS = function euiSpinnerBorderColorsCSS(_ref) {
  var euiTheme = _ref.euiTheme;
  var colors = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _colors$border = colors.border,
    border = _colors$border === void 0 ? euiTheme.colors.lightShade : _colors$border,
    _colors$highlight = colors.highlight,
    highlight = _colors$highlight === void 0 ? euiTheme.colors.primary : _colors$highlight;
  return "".concat(highlight, " ").concat(border, " ").concat(border, " ").concat(border);
};
exports.euiSpinnerBorderColorsCSS = euiSpinnerBorderColorsCSS;
var euiLoadingSpinnerStyles = function euiLoadingSpinnerStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiLoadingSpinner: /*#__PURE__*/(0, _react.css)("flex-shrink:0;display:inline-block;border-radius:50%;border:", euiTheme.border.thick, ";", (0, _global_styling.logicalShorthandCSS)('border-color', euiSpinnerBorderColorsCSS(euiThemeContext)), " ", _global_styling.euiCanAnimate, "{animation:", _loadingSpinner, " 0.6s infinite linear;};label:euiLoadingSpinner;"),
    // Sizes
    s: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size[spinnerSizes.s], euiTheme.size[spinnerSizes.s]), " border-width:", (0, _global_styling.mathWithUnits)(euiTheme.border.width.thin, function (x) {
      return x * 1.5;
    }), ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size[spinnerSizes.m], euiTheme.size[spinnerSizes.m]), " border-width:", (0, _global_styling.mathWithUnits)(euiTheme.border.width.thin, function (x) {
      return x * 1.5;
    }), ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size[spinnerSizes.l], euiTheme.size[spinnerSizes.l]), ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size[spinnerSizes.xl], euiTheme.size[spinnerSizes.xl]), ";;label:xl;"),
    xxl: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size[spinnerSizes.xxl], euiTheme.size[spinnerSizes.xxl]), ";;label:xxl;")
  };
};
exports.euiLoadingSpinnerStyles = euiLoadingSpinnerStyles;